/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graph;

public class AtlasEdgeLabel {
    private final String typeName_;
    private final String attributeName_;
    private final String mapKey_;
    private final String edgeLabel_;
    private final String qualifiedMapKey_;
    private final String qualifiedAttributeName_;

    public AtlasEdgeLabel(String edgeLabel) {
        String labelWithoutPrefix = edgeLabel.substring("__".length());
        String[] fields = labelWithoutPrefix.split("\\.", 3);
        if (fields.length < 2 || fields.length > 3) {
            throw new IllegalArgumentException("Invalid edge label " + edgeLabel + ": expected 2 or 3 label components but found " + fields.length);
        }
        this.typeName_ = fields[0];
        this.attributeName_ = fields[1];
        if (fields.length == 3) {
            this.mapKey_ = fields[2];
            this.qualifiedMapKey_ = labelWithoutPrefix;
            this.qualifiedAttributeName_ = this.typeName_ + '.' + this.attributeName_;
        } else {
            this.mapKey_ = null;
            this.qualifiedMapKey_ = null;
            this.qualifiedAttributeName_ = labelWithoutPrefix;
        }
        this.edgeLabel_ = edgeLabel;
    }

    public String getTypeName() {
        return this.typeName_;
    }

    public String getAttributeName() {
        return this.attributeName_;
    }

    public String getMapKey() {
        return this.mapKey_;
    }

    public String getEdgeLabel() {
        return this.edgeLabel_;
    }

    public String getQualifiedMapKey() {
        return this.qualifiedMapKey_;
    }

    public String getQualifiedAttributeName() {
        return this.qualifiedAttributeName_;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(').append("typeName: ").append(this.typeName_);
        sb.append(", attributeName: ").append(this.attributeName_);
        if (this.mapKey_ != null) {
            sb.append(", mapKey: ").append(this.mapKey_);
            sb.append(", qualifiedMapKey: ").append(this.qualifiedMapKey_);
        }
        sb.append(", edgeLabel: ").append(this.edgeLabel_).append(')');
        return sb.toString();
    }
}

