/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.patches;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.listener.ChangedTypeDefs;
import org.apache.atlas.model.patches.AtlasPatch;
import org.apache.atlas.repository.graph.SolrIndexHelper;
import org.apache.atlas.repository.patches.AtlasPatchHandler;
import org.apache.atlas.repository.patches.PatchContext;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreeTextRequestHandlerPatch
extends AtlasPatchHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FreeTextRequestHandlerPatch.class);
    private static final String PATCH_ID = "JAVA_PATCH_0000_003";
    private static final String PATCH_DESCRIPTION = "Creates Solr request handler for use in free-text searches";
    private final PatchContext context;

    public FreeTextRequestHandlerPatch(PatchContext context) {
        super(context.getPatchRegistry(), PATCH_ID, PATCH_DESCRIPTION);
        this.context = context;
    }

    @Override
    public void apply() throws AtlasBaseException {
        AtlasTypeRegistry typeRegistry = this.context.getTypeRegistry();
        Collection entityDefs = typeRegistry.getAllEntityDefs();
        if (CollectionUtils.isNotEmpty((Collection)entityDefs)) {
            SolrIndexHelper indexHelper = new SolrIndexHelper(typeRegistry);
            ChangedTypeDefs changedTypeDefs = new ChangedTypeDefs(null, new ArrayList(entityDefs), null);
            indexHelper.onChange(changedTypeDefs);
        }
        this.setStatus(AtlasPatch.PatchStatus.APPLIED);
        LOG.info("FreeTextRequestHandlerPatch.apply(): patchId={}, status={}", (Object)this.getPatchId(), (Object)this.getStatus());
    }
}

