/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2.tasks;

import java.util.Map;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.model.tasks.AtlasTask;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.store.graph.AtlasRelationshipStore;
import org.apache.atlas.repository.store.graph.v1.DeleteHandlerDelegate;
import org.apache.atlas.repository.store.graph.v2.EntityGraphMapper;
import org.apache.atlas.repository.store.graph.v2.tasks.ClassificationTask;
import org.apache.atlas.type.AtlasType;

public class ClassificationPropagationTasks {

    public static class UpdateRelationship
    extends ClassificationTask {
        public UpdateRelationship(AtlasTask task, AtlasGraph graph, EntityGraphMapper entityGraphMapper, DeleteHandlerDelegate deleteDelegate, AtlasRelationshipStore relationshipStore) {
            super(task, graph, entityGraphMapper, deleteDelegate, relationshipStore);
        }

        @Override
        protected void run(Map<String, Object> parameters) throws AtlasBaseException {
            String relationshipEdgeId = (String)parameters.get("relationshipEdgeId");
            AtlasRelationship relationship = (AtlasRelationship)AtlasType.fromJson((String)((String)parameters.get("relationshipObject")), AtlasRelationship.class);
            this.entityGraphMapper.updateTagPropagations(relationshipEdgeId, relationship);
        }
    }

    public static class Delete
    extends ClassificationTask {
        public Delete(AtlasTask task, AtlasGraph graph, EntityGraphMapper entityGraphMapper, DeleteHandlerDelegate deleteDelegate, AtlasRelationshipStore relationshipStore) {
            super(task, graph, entityGraphMapper, deleteDelegate, relationshipStore);
        }

        @Override
        protected void run(Map<String, Object> parameters) throws AtlasBaseException {
            String entityGuid = (String)parameters.get("entityGuid");
            String classificationVertexId = (String)parameters.get("classificationVertexId");
            this.entityGraphMapper.deleteClassificationPropagation(entityGuid, classificationVertexId);
        }
    }

    public static class Add
    extends ClassificationTask {
        public Add(AtlasTask task, AtlasGraph graph, EntityGraphMapper entityGraphMapper, DeleteHandlerDelegate deleteDelegate, AtlasRelationshipStore relationshipStore) {
            super(task, graph, entityGraphMapper, deleteDelegate, relationshipStore);
        }

        @Override
        protected void run(Map<String, Object> parameters) throws AtlasBaseException {
            String entityGuid = (String)parameters.get("entityGuid");
            String classificationVertexId = (String)parameters.get("classificationVertexId");
            String relationshipGuid = (String)parameters.get("relationshipGuid");
            this.entityGraphMapper.propagateClassification(entityGuid, classificationVertexId, relationshipGuid);
        }
    }
}

