/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Iterator;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.web.service.EmbeddedServer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public final class Atlas {
    private static final Logger LOG = LoggerFactory.getLogger(Atlas.class);
    private static final String APP_PATH = "app";
    private static final String APP_PORT = "port";
    private static final String ATLAS_HOME = "atlas.home";
    private static final String ATLAS_DATA = "atlas.data";
    private static final String ATLAS_LOG_DIR = "atlas.log.dir";
    public static final String ATLAS_SERVER_HTTPS_PORT = "atlas.server.https.port";
    public static final String ATLAS_SERVER_HTTP_PORT = "atlas.server.http.port";
    private static EmbeddedServer server;

    private static void shutdown() {
        server.stop();
    }

    private Atlas() {
    }

    protected static CommandLine parseArgs(String[] args) throws ParseException {
        Options options = new Options();
        Option opt = new Option(APP_PATH, true, "Application Path");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option(APP_PORT, true, "Application Port");
        opt.setRequired(false);
        options.addOption(opt);
        return new GnuParser().parse(options, args);
    }

    public static void main(String[] args) throws Exception {
        CommandLine cmd = Atlas.parseArgs(args);
        PropertiesConfiguration buildConfiguration = new PropertiesConfiguration("atlas-buildinfo.properties");
        String appPath = "webapp/target/atlas-webapp-" + Atlas.getProjectVersion(buildConfiguration);
        if (cmd.hasOption(APP_PATH)) {
            appPath = cmd.getOptionValue(APP_PATH);
        }
        Atlas.setApplicationHome();
        Configuration configuration = ApplicationProperties.get();
        String enableTLSFlag = configuration.getString("atlas.enableTLS");
        String appHost = configuration.getString("atlas.server.bind.address", "0.0.0.0");
        if (!Atlas.isLocalAddress(InetAddress.getByName(appHost))) {
            String msg = "Failed to start Atlas server. Address " + appHost + " does not belong to this host. Correct configuration parameter: " + "atlas.server.bind.address";
            LOG.error(msg);
            throw new IOException(msg);
        }
        int appPort = Atlas.getApplicationPort(cmd, enableTLSFlag, configuration);
        System.setProperty("atlas.app.port", String.valueOf(appPort));
        boolean enableTLS = Atlas.isTLSEnabled(enableTLSFlag, appPort);
        configuration.setProperty("atlas.enableTLS", (Object)String.valueOf(enableTLS));
        Atlas.showStartupInfo(buildConfiguration, enableTLS, appPort);
        server = EmbeddedServer.newServer(appHost, appPort, appPath, enableTLS);
        Atlas.installLogBridge();
        server.start();
    }

    private static void setApplicationHome() {
        if (System.getProperty(ATLAS_HOME) == null) {
            System.setProperty(ATLAS_HOME, "target");
        }
        if (System.getProperty(ATLAS_DATA) == null) {
            System.setProperty(ATLAS_DATA, "target/data");
        }
        if (System.getProperty(ATLAS_LOG_DIR) == null) {
            System.setProperty(ATLAS_LOG_DIR, "target/logs");
        }
    }

    public static String getProjectVersion(PropertiesConfiguration buildConfiguration) {
        return buildConfiguration.getString("project.version");
    }

    static int getApplicationPort(CommandLine cmd, String enableTLSFlag, Configuration configuration) {
        String optionValue = cmd.hasOption(APP_PORT) ? cmd.getOptionValue(APP_PORT) : null;
        int appPort = StringUtils.isNotEmpty((String)optionValue) ? Integer.valueOf(optionValue) : Atlas.getPortValue(configuration, enableTLSFlag);
        return appPort;
    }

    private static int getPortValue(Configuration configuration, String enableTLSFlag) {
        assert (configuration != null);
        int appPort = StringUtils.isEmpty((String)enableTLSFlag) || enableTLSFlag.equals("true") ? configuration.getInt(ATLAS_SERVER_HTTPS_PORT, 21443) : configuration.getInt(ATLAS_SERVER_HTTP_PORT, 21000);
        return appPort;
    }

    private static boolean isTLSEnabled(String enableTLSFlag, int appPort) {
        return Boolean.valueOf(StringUtils.isEmpty((String)enableTLSFlag) ? System.getProperty("atlas.enableTLS", appPort % 1000 == 443 ? "true" : "false") : enableTLSFlag);
    }

    private static boolean isLocalAddress(InetAddress addr) {
        boolean local;
        boolean bl = local = addr.isAnyLocalAddress() || addr.isLoopbackAddress();
        if (!local) {
            try {
                local = NetworkInterface.getByInetAddress(addr) != null;
            }
            catch (SocketException e) {
                local = false;
            }
        }
        return local;
    }

    private static void showStartupInfo(PropertiesConfiguration buildConfiguration, boolean enableTLS, int appPort) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n############################################");
        buffer.append("############################################");
        buffer.append("\n                               Atlas Server (STARTUP)");
        buffer.append("\n");
        try {
            Iterator keys = buildConfiguration.getKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                buffer.append('\n').append('\t').append(key).append(":\t").append(buildConfiguration.getProperty(key));
            }
        }
        catch (Throwable e) {
            buffer.append("*** Unable to get build info ***");
        }
        buffer.append("\n############################################");
        buffer.append("############################################");
        LOG.info(buffer.toString());
        LOG.info(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        LOG.info("Server starting with TLS ? {} on port {}", (Object)enableTLS, (Object)appPort);
        LOG.info("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
    }

    private static void installLogBridge() {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }

    static {
        ShutdownHookManager.get().addShutdownHook((Runnable)new Thread(){

            @Override
            public void run() {
                try {
                    LOG.info("==> Shutdown of Atlas");
                    Atlas.shutdown();
                }
                catch (Exception e) {
                    LOG.error("Failed to shutdown", (Throwable)e);
                }
                finally {
                    LOG.info("<== Shutdown of Atlas");
                }
            }
        }, 30);
    }
}

