/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.service;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.framework.AuthInfo;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;

public class AtlasZookeeperSecurityProperties {
    public static ACL parseAcl(String aclString, ACL defaultAcl) {
        if (StringUtils.isEmpty((String)aclString)) {
            return defaultAcl;
        }
        return AtlasZookeeperSecurityProperties.parseAcl(aclString);
    }

    public static ACL parseAcl(String aclString) {
        String[] aclComponents = AtlasZookeeperSecurityProperties.getComponents(aclString, "acl", "scheme:id");
        return new ACL(31, new Id(aclComponents[0], aclComponents[1]));
    }

    private static String[] getComponents(String securityString, String variableName, String formatExample) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)securityString) ? 1 : 0) != 0, (Object)String.format("%s cannot be null or empty. Needs to be of form %s", variableName, formatExample));
        String[] aclComponents = securityString.split(":", 2);
        if (aclComponents.length != 2) {
            throw new IllegalArgumentException(String.format("Invalid %s string. Needs to be of form %s", variableName, formatExample));
        }
        return aclComponents;
    }

    public static AuthInfo parseAuth(String authString) {
        String[] authComponents = AtlasZookeeperSecurityProperties.getComponents(authString, "authString", "scheme:authString");
        return new AuthInfo(authComponents[0], authComponents[1].getBytes(Charsets.UTF_8));
    }
}

