/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.service;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.atlas.web.service.AtlasDebugMetricsSink;
import org.apache.atlas.web.service.AtlasDebugMetricsSource;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.aspectj.lang.Signature;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class DebugMetricsWrapper {
    private AtlasDebugMetricsSource debugMetricsSource = new AtlasDebugMetricsSource();
    @Inject
    AtlasDebugMetricsSink debugMetricsRESTSink;

    @PostConstruct
    public void init() {
        MetricsSystem metricsSystem = DefaultMetricsSystem.initialize((String)"atlas-debug-metrics-context");
        metricsSystem.register((Object)this.debugMetricsSource);
        metricsSystem.register("AtlasDebugMetricsRESTSink", "", (MetricsSink)this.debugMetricsRESTSink);
    }

    public void update(Signature name, long timeConsumed) {
        this.debugMetricsSource.update(name, (Long)timeConsumed);
    }

    class Constants {
        public static final String NUM_OPS = "numops";
        public static final String MIN_TIME = "mintime";
        public static final String MAX_TIME = "maxtime";
        public static final String STD_DEV_TIME = "stdevtime";
        public static final String AVG_TIME = "avgtime";
        public static final String DEBUG_METRICS_SOURCE = "AtlasDebugMetricsSource";
        public static final String DEBUG_METRICS_CONTEXT = "atlas-debug-metrics-context";
        public static final String DEBUG_METRICS_REST_SINK = "AtlasDebugMetricsRESTSink";
        public static final String EntityRESTPrefix = "EntityREST.";
        public static final String TypesRESTPrefix = "TypesREST.";
        public static final String GlossaryRESTPrefix = "GlossaryREST.";
        public static final String DiscoveryRESTPrefix = "DiscoveryREST.";
        public static final String LineageRESTPrefix = "LineageREST.";
        public static final String RelationshipRESTPrefix = "RelationshipREST.";
        public static final String EntityREST_getById = "EntityREST.getById(..)";
        public static final String EntityREST_createOrUpdate = "EntityREST.createOrUpdate(..)";
        public static final String EntityREST_partialUpdateEntityAttrByGuid = "EntityREST.partialUpdateEntityAttrByGuid(..)";
        public static final String EntityREST_deleteByGuid = "EntityREST.deleteByGuid(..)";
        public static final String EntityREST_getClassification = "EntityREST.getClassification(..)";
        public static final String EntityREST_getClassifications = "EntityREST.getClassifications(..)";
        public static final String EntityREST_addClassificationsByUA = "EntityREST.addClassificationsByUniqueAttribute(..)";
        public static final String EntityREST_addClassifications = "EntityREST.addClassifications(..)";
        public static final String EntityREST_deleteClassificationByUA = "EntityREST.deleteClassificationByUniqueAttribute(..)";
        public static final String EntityREST_deleteClassification = "EntityREST.deleteClassification(..)";
        public static final String EntityREST_getHeaderById = "EntityREST.getHeaderById(..)";
        public static final String EntityREST_getEntityHeaderByUA = "EntityREST.getEntityHeaderByUniqueAttributes(..)";
        public static final String EntityREST_getByUniqueAttributes = "EntityREST.getByUniqueAttributes(..)";
        public static final String EntityREST_partialUpdateEntityByUA = "EntityREST.partialUpdateEntityByUniqueAttrs(..)";
        public static final String EntityREST_deleteByUA = "EntityREST.deleteByUniqueAttribute(..)";
        public static final String EntityREST_updateClassificationsByUA = "EntityREST.updateClassificationsByUniqueAttribute(..)";
        public static final String EntityREST_updateClassifications = "EntityREST.updateClassifications(..)";
        public static final String EntityREST_getEntitiesByUA = "EntityREST.getEntitiesByUniqueAttributes(..)";
        public static final String EntityREST_getByGuids = "EntityREST.getByGuids(..)";
        public static final String EntityREST_deleteByGuids = "EntityREST.deleteByGuids(..)";
        public static final String EntityREST_addClassification = "EntityREST.addClassification(..)";
        public static final String EntityREST_getAuditEvents = "EntityREST.getAuditEvents(..)";
        public static final String EntityREST_getEntityHeaders = "EntityREST.getEntityHeaders(..)";
        public static final String EntityREST_setClassifications = "EntityREST.setClassifications(..)";
        public static final String EntityREST_addOrUpdateBusinessAttributes = "EntityREST.addOrUpdateBusinessAttributes(..)";
        public static final String EntityREST_removeBusinessAttributes = "EntityREST.removeBusinessAttributes(..)";
        public static final String EntityREST_setLabels = "EntityREST.setLabels(..)";
        public static final String EntityREST_addLabels = "EntityREST.addLabels(..)";
        public static final String EntityREST_removeLabels = "EntityREST.removeLabels(..)";
        public static final String EntityREST_importBMAttributes = "EntityREST.importBMAttributes(..)";
        public static final String TypesREST_getTypeDefByName = "TypesREST.getTypeDefByName(..)";
        public static final String TypesREST_getTypeDefByGuid = "TypesREST.getTypeDefByGuid(..)";
        public static final String TypesREST_getTypeDefHeaders = "TypesREST.getTypeDefHeaders(..)";
        public static final String TypesREST_getAllTypeDefs = "TypesREST.getAllTypeDefs(..)";
        public static final String TypesREST_getEnumDefByName = "TypesREST.getEnumDefByName(..)";
        public static final String TypesREST_getEnumDefByGuid = "TypesREST.getEnumDefByGuid(..)";
        public static final String TypesREST_getStructDefByName = "TypesREST.getStructDefByName(..)";
        public static final String TypesREST_getStructDefByGuid = "TypesREST.getStructDefByGuid(..)";
        public static final String TypesREST_getClassificationDefByName = "TypesREST.getClassificationDefByName(..)";
        public static final String TypesREST_getClassificationDefByGuid = "TypesREST.getClassificationDefByGuid(..)";
        public static final String TypesREST_getEntityDefByName = "TypesREST.getEntityDefByName(..)";
        public static final String TypesREST_getEntityDefByGuid = "TypesREST.getEntityDefByGuid(..)";
        public static final String TypesREST_getRelationshipDefByName = "TypesREST.getRelationshipDefByName(..)";
        public static final String TypesREST_getRelationshipDefByGuid = "TypesREST.getRelationshipDefByGuid(..)";
        public static final String TypesREST_getBusinessMetadataDefByGuid = "TypesREST.getBusinessMetadataDefByGuid(..)";
        public static final String TypesREST_getBusinessMetadataDefByName = "TypesREST.getBusinessMetadataDefByName(..)";
        public static final String TypesREST_createAtlasTypeDefs = "TypesREST.createAtlasTypeDefs(..)";
        public static final String TypesREST_updateAtlasTypeDefs = "TypesREST.updateAtlasTypeDefs(..)";
        public static final String TypesREST_deleteAtlasTypeDefs = "TypesREST.deleteAtlasTypeDefs(..)";
        public static final String TypesREST_deleteAtlasTypeByName = "TypesREST.deleteAtlasTypeByName(..)";
        public static final String GlossaryREST_getGlossaries = "GlossaryREST.getGlossaries(..)";
        public static final String GlossaryREST_getGlossary = "GlossaryREST.getGlossary(..)";
        public static final String GlossaryREST_getDetailedGlossary = "GlossaryREST.getDetailedGlossary(..)";
        public static final String GlossaryREST_getGlossaryTerm = "GlossaryREST.getGlossaryTerm(..)";
        public static final String GlossaryREST_getGlossaryCategory = "GlossaryREST.getGlossaryCategory(..)";
        public static final String GlossaryREST_createGlossary = "GlossaryREST.createGlossary(..)";
        public static final String GlossaryREST_createGlossaryTerm = "GlossaryREST.createGlossaryTerm(..)";
        public static final String GlossaryREST_createGlossaryTerms = "GlossaryREST.createGlossaryTerms(..)";
        public static final String GlossaryREST_createGlossaryCategory = "GlossaryREST.createGlossaryCategory(..)";
        public static final String GlossaryREST_createGlossaryCategories = "GlossaryREST.createGlossaryCategories(..)";
        public static final String GlossaryREST_updateGlossary = "GlossaryREST.updateGlossary(..)";
        public static final String GlossaryREST_partialUpdateGlossary = "GlossaryREST.partialUpdateGlossary(..)";
        public static final String GlossaryREST_updateGlossaryTerm = "GlossaryREST.updateGlossaryTerm(..)";
        public static final String GlossaryREST_partialUpdateGlossaryTerm = "GlossaryREST.partialUpdateGlossaryTerm(..)";
        public static final String GlossaryREST_updateGlossaryCategory = "GlossaryREST.updateGlossaryCategory(..)";
        public static final String GlossaryREST_partialUpdateGlossaryCategory = "GlossaryREST.partialUpdateGlossaryCategory(..)";
        public static final String GlossaryREST_deleteGlossary = "GlossaryREST.deleteGlossary(..)";
        public static final String GlossaryREST_deleteGlossaryTerm = "GlossaryREST.deleteGlossaryTerm(..)";
        public static final String GlossaryREST_deleteGlossaryCategory = "GlossaryREST.deleteGlossaryCategory(..)";
        public static final String GlossaryREST_getGlossaryTerms = "GlossaryREST.getGlossaryTerms(..)";
        public static final String GlossaryREST_getGlossaryTermHeaders = "GlossaryREST.getGlossaryTermHeaders(..)";
        public static final String GlossaryREST_getGlossaryCategories = "GlossaryREST.getGlossaryCategories(..)";
        public static final String GlossaryREST_getGlossaryCategoriesHeaders = "GlossaryREST.getGlossaryCategoriesHeaders(..)";
        public static final String GlossaryREST_getCategoryTerms = "GlossaryREST.getCategoryTerms(..)";
        public static final String GlossaryREST_getRelatedTerms = "GlossaryREST.getRelatedTerms(..)";
        public static final String GlossaryREST_getEntitiesAssignedWithTerm = "GlossaryREST.getEntitiesAssignedWithTerm(..)";
        public static final String GlossaryREST_assignTermToEntities = "GlossaryREST.assignTermToEntities(..)";
        public static final String GlossaryREST_removeTermAssignmentFromEntities = "GlossaryREST.removeTermAssignmentFromEntities(..)";
        public static final String GlossaryREST_disassociateTermAssignmentFromEntities = "GlossaryREST.disassociateTermAssignmentFromEntities(..)";
        public static final String GlossaryREST_getRelatedCategories = "GlossaryREST.getRelatedCategories(..)";
        public static final String GlossaryREST_importGlossaryData = "GlossaryREST.importGlossaryData(..)";
        public static final String DiscoveryREST_searchUsingDSL = "DiscoveryREST.searchUsingDSL(..)";
        public static final String DiscoveryREST_searchUsingBasic = "DiscoveryREST.searchUsingBasic(..)";
        public static final String DiscoveryREST_quickSearch = "DiscoveryREST.quickSearch(..)";
        public static final String DiscoveryREST_addSavedSearch = "DiscoveryREST.addSavedSearch(..)";
        public static final String DiscoveryREST_searchUsingFullText = "DiscoveryREST.searchUsingFullText(..)";
        public static final String DiscoveryREST_searchUsingAttribute = "DiscoveryREST.searchUsingAttribute(..)";
        public static final String DiscoveryREST_searchWithParameters = "DiscoveryREST.searchWithParameters(..)";
        public static final String DiscoveryREST_searchRelatedEntities = "DiscoveryREST.searchRelatedEntities(..)";
        public static final String DiscoveryREST_updateSavedSearch = "DiscoveryREST.updateSavedSearch(..)";
        public static final String DiscoveryREST_getSavedSearch = "DiscoveryREST.getSavedSearch(..)";
        public static final String DiscoveryREST_getSavedSearches = "DiscoveryREST.getSavedSearches(..)";
        public static final String DiscoveryREST_deleteSavedSearch = "DiscoveryREST.deleteSavedSearch(..)";
        public static final String DiscoveryREST_executeSavedSearchByName = "DiscoveryREST.executeSavedSearchByName(..)";
        public static final String DiscoveryREST_executeSavedSearchByGuid = "DiscoveryREST.executeSavedSearchByGuid(..)";
        public static final String DiscoveryREST_getSuggestions = "DiscoveryREST.getSuggestions(..)";
        public static final String RelationshipREST_create = "RelationshipREST.create(..)";
        public static final String RelationshipREST_update = "RelationshipREST.update(..)";
        public static final String RelationshipREST_getById = "RelationshipREST.getById(..)";
        public static final String RelationshipREST_deleteById = "RelationshipREST.deleteById(..)";
        public static final String LineageREST_getLineageByUA = "LineageREST.getLineageByUniqueAttribute(..)";
        public static final String LineageREST_getLineageGraph = "LineageREST.getLineageGraph(..)";
        public static final String NotificationHookConsumer_doWork = "NotificationHookConsumer.doWork(..)";
        public static final String EntityREST_createOrUpdateBulk = "EntityMutationResponse org.apache.atlas.web.rest.EntityREST.createOrUpdate(AtlasEntitiesWithExtInfo)";
        public static final String EntityREST_removeLabelsByTypeName = "void org.apache.atlas.web.rest.EntityREST.removeLabels(String,Set,HttpServletRequest)";
        public static final String EntityREST_setLabelsByTypeName = "void org.apache.atlas.web.rest.EntityREST.setLabels(String,Set,HttpServletRequest)";
        public static final String EntityREST_addLabelsByTypeName = "void org.apache.atlas.web.rest.EntityREST.addLabels(String,Set,HttpServletRequest)";
        public static final String EntityREST_addOrUpdateBMByName = "void org.apache.atlas.web.rest.EntityREST.addOrUpdateBusinessAttributes(String,String,Map)";
        public static final String EntityREST_removeBMByName = "void org.apache.atlas.web.rest.EntityREST.removeBusinessAttributes(String,String,Map)";
        public static final String DiscoveryREST_quickSearchQuickSearchParams = "AtlasQuickSearchResult org.apache.atlas.web.rest.DiscoveryREST.quickSearch(QuickSearchParameters)";

        Constants() {
        }
    }
}

