/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.atlas.web.util.Servlets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Provider
@Produces(value={"application/json"})
@Component
public class AtlasJsonProvider
extends JacksonJaxbJsonProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasJsonProvider.class);
    private static final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);

    public AtlasJsonProvider() {
        super(mapper, JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS);
        LOG.info("AtlasJsonProvider() instantiated");
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            return super.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream);
        }
        catch (JsonParseException jpe) {
            LOG.error("Malformed json passed to server", (Throwable)jpe);
            throw new WebApplicationException(Servlets.getErrorResponse(jpe.getMessage(), Response.Status.BAD_REQUEST));
        }
        catch (JsonMappingException jme) {
            LOG.error("Malformed json passed to server, incorrect data type used", (Throwable)jme);
            throw new WebApplicationException(Servlets.getErrorResponse(jme.getMessage(), Response.Status.BAD_REQUEST));
        }
    }
}

