/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.lineage.AtlasLineageInfo;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.v1.model.instance.Struct;

public final class LineageUtils {
    private static final String VERTEX_ID_ATTR_NAME = "vertexId";
    private static final String TEMP_STRUCT_ID_RESULT = "__IdType";
    private static final AtomicInteger COUNTER = new AtomicInteger();

    private LineageUtils() {
    }

    public static Struct toLineageStruct(AtlasLineageInfo lineageInfo, AtlasTypeRegistry registry) throws AtlasBaseException {
        Struct ret = new Struct();
        ret.setTypeName("__tempQueryResultStruct" + COUNTER.getAndIncrement());
        if (lineageInfo != null) {
            Map entities = lineageInfo.getGuidEntityMap();
            Set relations = lineageInfo.getRelations();
            AtlasLineageInfo.LineageDirection direction = lineageInfo.getLineageDirection();
            HashMap<String, Struct> verticesMap = new HashMap<String, Struct>();
            for (String guid : entities.keySet()) {
                AtlasEntityHeader entityHeader = (AtlasEntityHeader)entities.get(guid);
                if (!LineageUtils.isDataSet(entityHeader.getTypeName(), registry)) continue;
                HashMap<String, Object> vertexIdMap = new HashMap<String, Object>();
                vertexIdMap.put("guid", guid);
                vertexIdMap.put("state", entityHeader.getStatus() == AtlasEntity.Status.ACTIVE ? "ACTIVE" : "DELETED");
                vertexIdMap.put("typeName", entityHeader.getTypeName());
                Object qualifiedName = entityHeader.getAttribute("qualifiedName");
                if (qualifiedName == null) {
                    qualifiedName = entityHeader.getDisplayText();
                }
                HashMap<String, Object> values = new HashMap<String, Object>();
                values.put("qualifiedName", qualifiedName);
                values.put(VERTEX_ID_ATTR_NAME, LineageUtils.constructResultStruct(vertexIdMap, true));
                values.put("name", entityHeader.getDisplayText());
                verticesMap.put(guid, LineageUtils.constructResultStruct(values, false));
            }
            HashMap edgesMap = new HashMap();
            for (AtlasLineageInfo.LineageRelation relation : relations) {
                String fromEntityId = relation.getFromEntityId();
                String toEntityId = relation.getToEntityId();
                if (direction == AtlasLineageInfo.LineageDirection.INPUT) {
                    if (!edgesMap.containsKey(toEntityId)) {
                        edgesMap.put(toEntityId, new ArrayList());
                    }
                    ((List)edgesMap.get(toEntityId)).add(fromEntityId);
                    continue;
                }
                if (direction != AtlasLineageInfo.LineageDirection.OUTPUT) continue;
                if (!edgesMap.containsKey(fromEntityId)) {
                    edgesMap.put(fromEntityId, new ArrayList());
                }
                ((List)edgesMap.get(fromEntityId)).add(toEntityId);
            }
            ret.set("vertices", verticesMap);
            ret.set("edges", edgesMap);
        }
        return ret;
    }

    private static Struct constructResultStruct(Map<String, Object> values, boolean idType) {
        if (idType) {
            return new Struct(TEMP_STRUCT_ID_RESULT, values);
        }
        return new Struct("__tempQueryResultStruct" + COUNTER.getAndIncrement(), values);
    }

    private static boolean isDataSet(String typeName, AtlasTypeRegistry registry) throws AtlasBaseException {
        boolean ret = false;
        AtlasType type = registry.getType(typeName);
        if (type instanceof AtlasEntityType) {
            AtlasEntityType entityType = (AtlasEntityType)type;
            ret = entityType.getAllSuperTypes().contains("DataSet");
        }
        return ret;
    }
}

