/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.traversal.strategy.decoration;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.tinkerpop.gremlin.process.computer.Computer;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.VertexComputing;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.ComputerResultStep;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.ProgramVertexProgramStep;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.TraversalVertexProgramStep;
import org.apache.tinkerpop.gremlin.process.remote.traversal.strategy.decoration.RemoteStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class VertexProgramStrategy
extends AbstractTraversalStrategy<TraversalStrategy.DecorationStrategy>
implements TraversalStrategy.DecorationStrategy {
    private static final VertexProgramStrategy INSTANCE = new VertexProgramStrategy(Computer.compute());
    private final Computer computer;
    public static final String GRAPH_COMPUTER = "graphComputer";
    public static final String WORKERS = "workers";
    public static final String PERSIST = "persist";
    public static final String RESULT = "result";
    public static final String VERTICES = "vertices";
    public static final String EDGES = "edges";

    private VertexProgramStrategy() {
        this(null);
    }

    public VertexProgramStrategy(Computer computer) {
        this.computer = computer;
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        if (!(traversal.getParent() instanceof EmptyStep) || traversal.getStrategies().getStrategy(RemoteStrategy.class).isPresent()) {
            return;
        }
        Step<?, ?> currentStep = traversal.getEndStep();
        HashSet<String> currentLabels = new HashSet<String>();
        while (!(currentStep instanceof EmptyStep)) {
            if (currentStep instanceof VertexComputing && !(currentStep instanceof ProgramVertexProgramStep)) {
                currentLabels.addAll(currentStep.getLabels());
                currentStep.getLabels().forEach(currentStep::removeLabel);
            } else {
                currentLabels.forEach(currentStep::addLabel);
                currentLabels.clear();
            }
            currentStep = currentStep.getPreviousStep();
        }
        currentStep = traversal.getStartStep();
        while (!(currentStep instanceof EmptyStep)) {
            if (currentStep instanceof GraphStep && currentStep.getNextStep() instanceof VertexComputing) {
                int index = TraversalHelper.stepIndex(currentStep.getNextStep(), traversal);
                traversal.removeStep(currentStep);
                traversal.addStep(index, currentStep);
                continue;
            }
            currentStep = currentStep.getNextStep();
        }
        currentStep = traversal.getStartStep();
        while (!(currentStep instanceof EmptyStep)) {
            DefaultTraversal computerTraversal = new DefaultTraversal();
            Step<?, ?> firstLegalOLAPStep = VertexProgramStrategy.getFirstLegalOLAPStep(currentStep);
            Step<?, ?> lastLegalOLAPStep = VertexProgramStrategy.getLastLegalOLAPStep(currentStep);
            if (!(firstLegalOLAPStep instanceof EmptyStep)) {
                int index = TraversalHelper.stepIndex(firstLegalOLAPStep, traversal);
                TraversalHelper.removeToTraversal(firstLegalOLAPStep, lastLegalOLAPStep.getNextStep(), computerTraversal);
                TraversalVertexProgramStep traversalVertexProgramStep = new TraversalVertexProgramStep(traversal, computerTraversal);
                traversal.addStep(index, traversalVertexProgramStep);
            }
            currentStep = traversal.getStartStep();
            while (!(currentStep instanceof EmptyStep) && currentStep instanceof VertexComputing) {
                currentStep = currentStep.getNextStep();
            }
        }
        TraversalHelper.getLastStepOfAssignableClass(VertexComputing.class, traversal).ifPresent(step -> {
            if (step instanceof TraversalVertexProgramStep) {
                ComputerResultStep computerResultStep = new ComputerResultStep(traversal);
                ((TraversalVertexProgramStep)step).getGlobalChildren().get(0).getEndStep().getLabels().forEach(computerResultStep::addLabel);
                TraversalHelper.insertAfterStep(computerResultStep, (Step)((Object)step), traversal);
            }
        });
        if (traversal.getEndStep() instanceof VertexComputing && !(traversal.getEndStep() instanceof TraversalVertexProgramStep)) {
            TraversalVertexProgramStep traversalVertexProgramStep = new TraversalVertexProgramStep(traversal, __.identity().asAdmin());
            traversal.addStep(traversalVertexProgramStep);
            traversal.addStep(new ComputerResultStep(traversal));
        }
        traversal.getSteps().stream().filter(step -> step instanceof VertexComputing).forEach(step -> ((VertexComputing)((Object)step)).setComputer(this.computer));
    }

    private static Step<?, ?> getFirstLegalOLAPStep(Step<?, ?> currentStep) {
        while (!(currentStep instanceof EmptyStep)) {
            if (!(currentStep instanceof VertexComputing)) {
                return currentStep;
            }
            currentStep = currentStep.getNextStep();
        }
        return EmptyStep.instance();
    }

    private static Step<?, ?> getLastLegalOLAPStep(Step<?, ?> currentStep) {
        while (currentStep instanceof VertexComputing) {
            currentStep = currentStep.getNextStep();
        }
        while (!(currentStep instanceof EmptyStep)) {
            if (currentStep instanceof VertexComputing) {
                return currentStep.getPreviousStep();
            }
            currentStep = currentStep.getNextStep();
        }
        return EmptyStep.instance();
    }

    public static Optional<Computer> getComputer(TraversalStrategies strategies) {
        Optional<TraversalStrategy> optional = strategies.toList().stream().filter(strategy -> strategy instanceof VertexProgramStrategy).findAny();
        return optional.isPresent() ? Optional.of(((VertexProgramStrategy)optional.get()).computer) : Optional.empty();
    }

    public void addGraphComputerStrategies(TraversalSource traversalSource) {
        Class<GraphComputer> graphComputerClass;
        if (this.computer.getGraphComputerClass().equals(GraphComputer.class)) {
            try {
                graphComputerClass = this.computer.apply(traversalSource.getGraph()).getClass();
            }
            catch (Exception e) {
                graphComputerClass = GraphComputer.class;
            }
        } else {
            graphComputerClass = this.computer.getGraphComputerClass();
        }
        List<TraversalStrategy<?>> graphComputerStrategies = TraversalStrategies.GlobalCache.getStrategies(graphComputerClass).toList();
        traversalSource.getStrategies().addStrategies(graphComputerStrategies.toArray(new TraversalStrategy[graphComputerStrategies.size()]));
    }

    public static VertexProgramStrategy instance() {
        return INSTANCE;
    }

    @Override
    public Configuration getConfiguration() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(GRAPH_COMPUTER, this.computer.getGraphComputerClass().getCanonicalName());
        if (-1 != this.computer.getWorkers()) {
            map.put(WORKERS, this.computer.getWorkers());
        }
        if (null != this.computer.getPersist()) {
            map.put(PERSIST, this.computer.getPersist().name());
        }
        if (null != this.computer.getResultGraph()) {
            map.put(RESULT, this.computer.getResultGraph().name());
        }
        if (null != this.computer.getVertices()) {
            map.put(VERTICES, this.computer.getVertices());
        }
        if (null != this.computer.getEdges()) {
            map.put(EDGES, this.computer.getEdges());
        }
        map.putAll(this.computer.getConfiguration());
        return new MapConfiguration(map);
    }

    public static VertexProgramStrategy create(Configuration configuration) {
        try {
            Builder builder = VertexProgramStrategy.build();
            for (String key : IteratorUtils.asList(configuration.getKeys())) {
                if (key.equals(GRAPH_COMPUTER)) {
                    builder.graphComputer(Class.forName(configuration.getString(key)));
                    continue;
                }
                if (key.equals(WORKERS)) {
                    builder.workers(configuration.getInt(key));
                    continue;
                }
                if (key.equals(PERSIST)) {
                    builder.persist(GraphComputer.Persist.valueOf(configuration.getString(key)));
                    continue;
                }
                if (key.equals(RESULT)) {
                    builder.result(GraphComputer.ResultGraph.valueOf(configuration.getString(key)));
                    continue;
                }
                if (key.equals(VERTICES)) {
                    builder.vertices((Traversal)configuration.getProperty(key));
                    continue;
                }
                if (key.equals(EDGES)) {
                    builder.edges((Traversal)configuration.getProperty(key));
                    continue;
                }
                builder.configure(key, configuration.getProperty(key));
            }
            return builder.create();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static Builder build() {
        return new Builder();
    }

    public static final class Builder {
        private Computer computer = Computer.compute();

        private Builder() {
        }

        public Builder computer(Computer computer) {
            this.computer = computer;
            return this;
        }

        public Builder graphComputer(Class<? extends GraphComputer> graphComputerClass) {
            this.computer = this.computer.graphComputer(graphComputerClass);
            return this;
        }

        public Builder configure(String key, Object value) {
            this.computer = this.computer.configure(key, value);
            return this;
        }

        public Builder configure(Map<String, Object> configurations) {
            this.computer = this.computer.configure(configurations);
            return this;
        }

        public Builder workers(int workers) {
            this.computer = this.computer.workers(workers);
            return this;
        }

        public Builder persist(GraphComputer.Persist persist) {
            this.computer = this.computer.persist(persist);
            return this;
        }

        public Builder result(GraphComputer.ResultGraph resultGraph) {
            this.computer = this.computer.result(resultGraph);
            return this;
        }

        public Builder vertices(Traversal<Vertex, Vertex> vertices) {
            this.computer = this.computer.vertices(vertices);
            return this;
        }

        public Builder edges(Traversal<Vertex, Edge> edges) {
            this.computer = this.computer.edges(edges);
            return this;
        }

        public VertexProgramStrategy create() {
            return new VertexProgramStrategy(this.computer);
        }
    }
}

