/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.util.function.BiPredicate;

public enum Text implements BiPredicate<String, String>
{
    startingWith{

        @Override
        public boolean test(String value, String prefix) {
            return value.startsWith(prefix);
        }

        @Override
        public Text negate() {
            return notStartingWith;
        }
    }
    ,
    notStartingWith{

        @Override
        public boolean test(String value, String prefix) {
            return !startingWith.test(value, prefix);
        }

        @Override
        public Text negate() {
            return startingWith;
        }
    }
    ,
    endingWith{

        @Override
        public boolean test(String value, String suffix) {
            return value.endsWith(suffix);
        }

        @Override
        public Text negate() {
            return notEndingWith;
        }
    }
    ,
    notEndingWith{

        @Override
        public boolean test(String value, String prefix) {
            return !endingWith.test(value, prefix);
        }

        @Override
        public Text negate() {
            return endingWith;
        }
    }
    ,
    containing{

        @Override
        public boolean test(String value, String search) {
            return value.contains(search);
        }

        @Override
        public Text negate() {
            return notContaining;
        }
    }
    ,
    notContaining{

        @Override
        public boolean test(String value, String search) {
            return !containing.test(value, search);
        }

        @Override
        public Text negate() {
            return containing;
        }
    };


    public abstract Text negate();
}

