/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.shaded.kryo.serializers;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.Serializer;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapSerializer
extends Serializer<Map> {
    private Class keyClass;
    private Class valueClass;
    private Serializer keySerializer;
    private Serializer valueSerializer;
    private boolean keysCanBeNull = true;
    private boolean valuesCanBeNull = true;
    private Class keyGenericType;
    private Class valueGenericType;

    public void setKeysCanBeNull(boolean keysCanBeNull) {
        this.keysCanBeNull = keysCanBeNull;
    }

    public void setKeyClass(Class keyClass, Serializer keySerializer) {
        this.keyClass = keyClass;
        this.keySerializer = keySerializer;
    }

    public void setValueClass(Class valueClass, Serializer valueSerializer) {
        this.valueClass = valueClass;
        this.valueSerializer = valueSerializer;
    }

    public void setValuesCanBeNull(boolean valuesCanBeNull) {
        this.valuesCanBeNull = valuesCanBeNull;
    }

    @Override
    public void setGenerics(Kryo kryo, Class[] generics) {
        this.keyGenericType = null;
        this.valueGenericType = null;
        if (generics != null && generics.length > 0) {
            if (generics[0] != null && kryo.isFinal(generics[0])) {
                this.keyGenericType = generics[0];
            }
            if (generics.length > 1 && generics[1] != null && kryo.isFinal(generics[1])) {
                this.valueGenericType = generics[1];
            }
        }
    }

    @Override
    public void write(Kryo kryo, Output output, Map map) {
        int length = map.size();
        output.writeInt(length, true);
        Serializer keySerializer = this.keySerializer;
        if (this.keyGenericType != null) {
            if (keySerializer == null) {
                keySerializer = kryo.getSerializer(this.keyGenericType);
            }
            this.keyGenericType = null;
        }
        Serializer valueSerializer = this.valueSerializer;
        if (this.valueGenericType != null) {
            if (valueSerializer == null) {
                valueSerializer = kryo.getSerializer(this.valueGenericType);
            }
            this.valueGenericType = null;
        }
        for (Map.Entry entry : map.entrySet()) {
            if (keySerializer != null) {
                if (this.keysCanBeNull) {
                    kryo.writeObjectOrNull(output, entry.getKey(), keySerializer);
                } else {
                    kryo.writeObject(output, entry.getKey(), keySerializer);
                }
            } else {
                kryo.writeClassAndObject(output, entry.getKey());
            }
            if (valueSerializer != null) {
                if (this.valuesCanBeNull) {
                    kryo.writeObjectOrNull(output, entry.getValue(), valueSerializer);
                    continue;
                }
                kryo.writeObject(output, entry.getValue(), valueSerializer);
                continue;
            }
            kryo.writeClassAndObject(output, entry.getValue());
        }
    }

    protected Map create(Kryo kryo, Input input, Class<Map> type) {
        return kryo.newInstance(type);
    }

    @Override
    public Map read(Kryo kryo, Input input, Class<Map> type) {
        Map map = this.create(kryo, input, type);
        int length = input.readInt(true);
        Class keyClass = this.keyClass;
        Class valueClass = this.valueClass;
        Serializer keySerializer = this.keySerializer;
        if (this.keyGenericType != null) {
            keyClass = this.keyGenericType;
            if (keySerializer == null) {
                keySerializer = kryo.getSerializer(keyClass);
            }
            this.keyGenericType = null;
        }
        Serializer valueSerializer = this.valueSerializer;
        if (this.valueGenericType != null) {
            valueClass = this.valueGenericType;
            if (valueSerializer == null) {
                valueSerializer = kryo.getSerializer(valueClass);
            }
            this.valueGenericType = null;
        }
        kryo.reference(map);
        for (int i = 0; i < length; ++i) {
            Object key = keySerializer != null ? (this.keysCanBeNull ? kryo.readObjectOrNull(input, keyClass, keySerializer) : kryo.readObject(input, keyClass, keySerializer)) : kryo.readClassAndObject(input);
            Object value = valueSerializer != null ? (this.valuesCanBeNull ? kryo.readObjectOrNull(input, valueClass, valueSerializer) : kryo.readObject(input, valueClass, valueSerializer)) : kryo.readClassAndObject(input);
            map.put(key, value);
        }
        return map;
    }

    protected Map createCopy(Kryo kryo, Map original) {
        return (Map)kryo.newInstance(original.getClass());
    }

    @Override
    public Map copy(Kryo kryo, Map original) {
        Map copy = this.createCopy(kryo, original);
        for (Map.Entry entry : original.entrySet()) {
            copy.put(kryo.copy(entry.getKey()), kryo.copy(entry.getValue()));
        }
        return copy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface BindMap {
        public Class<? extends Serializer> keySerializer() default Serializer.class;

        public Class<? extends Serializer> valueSerializer() default Serializer.class;

        public Class<?> keyClass() default Object.class;

        public Class<?> valueClass() default Object.class;

        public boolean keysCanBeNull() default true;

        public boolean valuesCanBeNull() default true;
    }
}

