/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.janusgraph.graphdb.util.CloseableAbstractIterator;
import org.janusgraph.graphdb.util.MultiIterator;

public class CloseableIteratorUtils {
    public static final CloseableIterator<Object> EMPTY_CLOSABLE_ITERATOR = CloseableIterator.asCloseable(Collections.emptyIterator());

    public static <T> CloseableIterator<T> emptyIterator() {
        return EMPTY_CLOSABLE_ITERATOR;
    }

    public static <T> CloseableIterator<T> concat(Iterator<T> ... iterators) {
        return CloseableIteratorUtils.concat(Arrays.asList(iterators));
    }

    public static <T> CloseableIterator<T> concat(List<Iterator<T>> iterators) {
        return new MultiIterator(iterators);
    }

    public static <T> CloseableIterator<T> filter(final Iterator<T> unfiltered, final Predicate<? super T> retainIfTrue) {
        Objects.requireNonNull(unfiltered);
        Objects.requireNonNull(retainIfTrue);
        return new CloseableAbstractIterator<T>(){

            protected T computeNext() {
                while (unfiltered.hasNext()) {
                    Object element = unfiltered.next();
                    if (!retainIfTrue.test(element)) continue;
                    return element;
                }
                this.close();
                return this.endOfData();
            }

            public void close() {
                CloseableIterator.closeIterator((Iterator)unfiltered);
            }
        };
    }
}

