/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Hash;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.handler.component.RealTimeGetComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.SolrCmdDistributor;
import org.apache.solr.update.UpdateCommand;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.UpdateShardHandler;
import org.apache.solr.update.VersionBucket;
import org.apache.solr.update.VersionInfo;
import org.apache.solr.update.processor.AtomicUpdateDocumentMerger;
import org.apache.solr.update.processor.DistributedUpdateProcessorFactory;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.util.TestInjection;
import org.apache.solr.util.TimeOut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedUpdateProcessor
extends UpdateRequestProcessor {
    static final String PARAM_WHITELIST_CTX_KEY = DistributedUpdateProcessor.class + "PARAM_WHITELIST_CTX_KEY";
    public static final String DISTRIB_FROM_SHARD = "distrib.from.shard";
    public static final String DISTRIB_FROM_COLLECTION = "distrib.from.collection";
    public static final String DISTRIB_FROM_PARENT = "distrib.from.parent";
    public static final String DISTRIB_FROM = "distrib.from";
    public static final String DISTRIB_INPLACE_PREVVERSION = "distrib.inplace.prevversion";
    protected static final String TEST_DISTRIB_SKIP_SERVERS = "test.distrib.skip.servers";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final int MAX_RETRIES_ON_FORWARD_DEAULT = Integer.getInteger("solr.retries.on.forward", 25);
    static final int MAX_RETRIES_TO_FOLLOWERS_DEFAULT = Integer.getInteger("solr.retries.to.followers", 3);
    public static final String COMMIT_END_POINT = "commit_end_point";
    public static final String LOG_REPLAY = "log_replay";
    private boolean finished = false;
    protected final SolrQueryRequest req;
    protected final SolrQueryResponse rsp;
    private final AtomicUpdateDocumentMerger docMerger;
    private final UpdateLog ulog;
    @VisibleForTesting
    VersionInfo vinfo;
    private final boolean versionsStored;
    private boolean returnVersions;
    private NamedList<Object> addsResponse = null;
    private NamedList<Object> deleteResponse = null;
    private NamedList<Object> deleteByQueryResponse = null;
    private CharsRefBuilder scratch;
    private final SchemaField idField;
    protected boolean isLeader = true;
    protected boolean forwardToLeader = false;
    protected boolean isSubShardLeader = false;
    protected boolean isIndexChanged = false;
    protected final int maxRetriesOnForward = MAX_RETRIES_ON_FORWARD_DEAULT;
    protected final int maxRetriesToFollowers = MAX_RETRIES_TO_FOLLOWERS_DEFAULT;
    protected UpdateCommand updateCommand;
    protected final Replica.Type replicaType;

    public DistributedUpdateProcessor(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        this(req, rsp, new AtomicUpdateDocumentMerger(req), next);
    }

    public DistributedUpdateProcessor(SolrQueryRequest req, SolrQueryResponse rsp, AtomicUpdateDocumentMerger docMerger, UpdateRequestProcessor next) {
        super(next);
        this.rsp = rsp;
        this.docMerger = docMerger;
        this.idField = req.getSchema().getUniqueKeyField();
        this.req = req;
        this.replicaType = this.computeReplicaType();
        this.ulog = req.getCore().getUpdateHandler().getUpdateLog();
        this.vinfo = this.ulog == null ? null : this.ulog.getVersionInfo();
        this.versionsStored = this.vinfo != null && this.vinfo.getVersionField() != null;
        this.returnVersions = req.getParams().getBool("versions", false);
        DistributedUpdateProcessorFactory.addParamToDistributedRequestWhitelist(this.req, "update.chain", TEST_DISTRIB_SKIP_SERVERS, "_version_", "expungeDeletes", "optimize", "maxSegments", "_route_");
    }

    protected Replica.Type computeReplicaType() {
        return Replica.Type.NRT;
    }

    boolean isLeader() {
        return this.isLeader;
    }

    @Override
    public void processAdd(AddUpdateCommand cmd) throws IOException {
        assert (TestInjection.injectFailUpdateRequests());
        this.setupRequest(cmd);
        if (!cmd.isInPlaceUpdate()) {
            cmd.prevVersion = cmd.getReq().getParams().getLong(DISTRIB_INPLACE_PREVVERSION, -1L);
        }
        boolean dropCmd = false;
        if (!this.forwardToLeader) {
            dropCmd = this.versionAdd(cmd);
        }
        if (dropCmd) {
            return;
        }
        this.doDistribAdd(cmd);
        if (this.returnVersions && this.rsp != null && this.idField != null) {
            if (this.addsResponse == null) {
                this.addsResponse = new NamedList(1);
                this.rsp.add("adds", this.addsResponse);
            }
            if (this.scratch == null) {
                this.scratch = new CharsRefBuilder();
            }
            this.idField.getType().indexedToReadable(cmd.getIndexedId(), this.scratch);
            this.addsResponse.add(this.scratch.toString(), (Object)cmd.getVersion());
        }
    }

    protected void doDistribAdd(AddUpdateCommand cmd) throws IOException {
    }

    private void doLocalAdd(AddUpdateCommand cmd) throws IOException {
        super.processAdd(cmd);
        this.isIndexChanged = true;
    }

    private void doLocalDelete(DeleteUpdateCommand cmd) throws IOException {
        super.processDelete(cmd);
        this.isIndexChanged = true;
    }

    public static int bucketHash(BytesRef idBytes) {
        assert (idBytes != null);
        return Hash.murmurhash3_x86_32((byte[])idBytes.bytes, (int)idBytes.offset, (int)idBytes.length, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean versionAdd(AddUpdateCommand cmd) throws IOException {
        BytesRef idBytes = cmd.getIndexedId();
        if (idBytes == null) {
            super.processAdd(cmd);
            return false;
        }
        if (this.vinfo == null) {
            if (AtomicUpdateDocumentMerger.isAtomicUpdate(cmd)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Atomic document updates are not supported unless <updateLog/> is configured");
            }
            super.processAdd(cmd);
            return false;
        }
        int bucketHash = DistributedUpdateProcessor.bucketHash(idBytes);
        long versionOnUpdate = cmd.getVersion();
        if (versionOnUpdate == 0L) {
            String versionOnUpdateS;
            Object o;
            SolrInputField versionField = cmd.getSolrInputDocument().getField("_version_");
            versionOnUpdate = versionField != null ? ((o = versionField.getValue()) instanceof Number ? ((Number)o).longValue() : Long.parseLong(o.toString())) : ((versionOnUpdateS = this.req.getParams().get("_version_")) == null ? 0L : Long.parseLong(versionOnUpdateS));
        }
        boolean isReplayOrPeersync = (cmd.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0;
        boolean leaderLogic = this.isLeader && !isReplayOrPeersync;
        boolean forwardedFromCollection = cmd.getReq().getParams().get(DISTRIB_FROM_COLLECTION) != null;
        VersionBucket bucket = this.vinfo.bucket(bucketHash);
        long dependentVersionFound = -1L;
        if (!leaderLogic && cmd.isInPlaceUpdate() && (dependentVersionFound = this.waitForDependentUpdates(cmd, versionOnUpdate, isReplayOrPeersync, bucket)) == -1L) {
            return true;
        }
        this.vinfo.lockForUpdate();
        try {
            long finalVersionOnUpdate = versionOnUpdate;
            boolean bl = bucket.runWithLock(this.vinfo.getVersionBucketLockTimeoutMs(), () -> this.doVersionAdd(cmd, finalVersionOnUpdate, isReplayOrPeersync, leaderLogic, forwardedFromCollection, bucket));
            return bl;
        }
        finally {
            this.vinfo.unlockForUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doVersionAdd(AddUpdateCommand cmd, long versionOnUpdate, boolean isReplayOrPeersync, boolean leaderLogic, boolean forwardedFromCollection, VersionBucket bucket) throws IOException {
        try {
            BytesRef idBytes = cmd.getIndexedId();
            bucket.signalAll();
            if (this.versionsStored) {
                long bucketVersion = bucket.highest;
                if (leaderLogic) {
                    if (forwardedFromCollection && this.ulog.getState() == UpdateLog.State.ACTIVE) {
                        if (log.isInfoEnabled()) {
                            log.info("Removing version field from doc: {}", (Object)cmd.getPrintableId());
                        }
                        cmd.solrDoc.remove((Object)"_version_");
                        versionOnUpdate = 0L;
                    }
                    this.getUpdatedDocument(cmd, versionOnUpdate);
                    if (forwardedFromCollection && this.ulog.getState() != UpdateLog.State.ACTIVE && !isReplayOrPeersync) {
                        if (log.isInfoEnabled()) {
                            log.info("Leader logic applied but update log is buffering: {}", (Object)cmd.getPrintableId());
                        }
                        cmd.setFlags(cmd.getFlags() | UpdateCommand.BUFFERING);
                        this.ulog.add(cmd);
                        boolean bl = true;
                        return bl;
                    }
                    if (versionOnUpdate != 0L) {
                        long foundVersion;
                        Long lastVersion = this.vinfo.lookupVersion(cmd.getIndexedId());
                        long l = foundVersion = lastVersion == null ? -1L : lastVersion;
                        if (!(versionOnUpdate == foundVersion || versionOnUpdate < 0L && foundVersion < 0L || versionOnUpdate == 1L && foundVersion > 0L)) {
                            if (!cmd.getReq().getParams().getBool("failOnVersionConflicts", true)) {
                                boolean bl = true;
                                return bl;
                            }
                            throw new SolrException(SolrException.ErrorCode.CONFLICT, "version conflict for " + cmd.getPrintableId() + " expected=" + versionOnUpdate + " actual=" + foundVersion);
                        }
                    }
                    long version = this.vinfo.getNewClock();
                    cmd.setVersion(version);
                    cmd.getSolrInputDocument().setField("_version_", (Object)version);
                    bucket.updateHighest(version);
                } else {
                    cmd.setVersion(versionOnUpdate);
                    if (this.shouldBufferUpdate(cmd, isReplayOrPeersync, this.ulog.getState())) {
                        cmd.setFlags(cmd.getFlags() | UpdateCommand.BUFFERING);
                        this.ulog.add(cmd);
                        boolean version = true;
                        return version;
                    }
                    if (cmd.isInPlaceUpdate()) {
                        long prev = cmd.prevVersion;
                        Long lastVersion = this.vinfo.lookupVersion(cmd.getIndexedId());
                        if (lastVersion == null || Math.abs(lastVersion) < prev) {
                            UpdateCommand fetchedFromLeader = this.fetchFullUpdateFromLeader(cmd, versionOnUpdate);
                            if (fetchedFromLeader instanceof DeleteUpdateCommand) {
                                if (log.isInfoEnabled()) {
                                    log.info("In-place update of {} failed to find valid lastVersion to apply to, and the document was deleted at the leader subsequently.", (Object)idBytes.utf8ToString());
                                }
                                this.versionDelete((DeleteUpdateCommand)fetchedFromLeader);
                                boolean bl = true;
                                return bl;
                            }
                            assert (fetchedFromLeader instanceof AddUpdateCommand);
                            if (log.isInfoEnabled()) {
                                log.info("In-place update of {} failed to find valid lastVersion to apply to, forced to fetch full doc from leader: {}", (Object)idBytes.utf8ToString(), (Object)fetchedFromLeader);
                            }
                            cmd.solrDoc = ((AddUpdateCommand)fetchedFromLeader).solrDoc;
                            cmd.prevVersion = -1L;
                            cmd.setVersion((Long)cmd.solrDoc.getFieldValue("_version_"));
                            assert (!cmd.isInPlaceUpdate());
                        } else {
                            if (lastVersion != null && Math.abs(lastVersion) > prev) {
                                log.info("Update was applied on version: {}, but last version I have is: {}. Dropping current update", (Object)prev, (Object)lastVersion);
                                boolean bl = true;
                                return bl;
                            }
                            if (bucketVersion != 0L && bucketVersion < versionOnUpdate) {
                                bucket.updateHighest(versionOnUpdate);
                            }
                        }
                    } else if (bucketVersion != 0L && bucketVersion < versionOnUpdate) {
                        bucket.updateHighest(versionOnUpdate);
                    } else {
                        Long lastVersion = this.vinfo.lookupVersion(cmd.getIndexedId());
                        if (lastVersion != null && Math.abs(lastVersion) >= versionOnUpdate) {
                            if (log.isDebugEnabled()) {
                                log.debug("Dropping add update due to version {}", (Object)idBytes.utf8ToString());
                            }
                            boolean bl = true;
                            return bl;
                        }
                    }
                    if (!this.isSubShardLeader && this.replicaType == Replica.Type.TLOG && (cmd.getFlags() & UpdateCommand.REPLAY) == 0) {
                        cmd.setFlags(cmd.getFlags() | UpdateCommand.IGNORE_INDEXWRITER);
                    }
                }
            }
            SolrInputDocument clonedDoc = this.shouldCloneCmdDoc() ? cmd.solrDoc.deepCopy() : null;
            this.doLocalAdd(cmd);
            if (this.req.getSchema().isUsableForChildDocs() && DistributedUpdateProcessor.shouldRefreshUlogCaches(cmd)) {
                this.ulog.openRealtimeSearcher();
            }
            if (clonedDoc != null) {
                cmd.solrDoc = clonedDoc;
            }
        }
        finally {
            bucket.unlock();
        }
        return false;
    }

    protected boolean shouldCloneCmdDoc() {
        return false;
    }

    @VisibleForTesting
    boolean shouldBufferUpdate(AddUpdateCommand cmd, boolean isReplayOrPeersync, UpdateLog.State state) {
        if (state == UpdateLog.State.APPLYING_BUFFERED && !isReplayOrPeersync && !cmd.isInPlaceUpdate()) {
            return false;
        }
        return state != UpdateLog.State.ACTIVE && !isReplayOrPeersync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long waitForDependentUpdates(AddUpdateCommand cmd, long versionOnUpdate, boolean isReplayOrPeersync, VersionBucket bucket) throws IOException {
        UpdateCommand missingUpdate;
        long lastFoundVersion = 0L;
        TimeOut waitTimeout = new TimeOut(5L, TimeUnit.SECONDS, TimeSource.NANO_TIME);
        this.vinfo.lockForUpdate();
        try {
            lastFoundVersion = bucket.runWithLock(this.vinfo.getVersionBucketLockTimeoutMs(), () -> this.doWaitForDependentUpdates(cmd, versionOnUpdate, isReplayOrPeersync, bucket, waitTimeout));
        }
        finally {
            this.vinfo.unlockForUpdate();
        }
        if (Math.abs(lastFoundVersion) > cmd.prevVersion) {
            if (log.isDebugEnabled()) {
                log.debug("Update was applied on version: {}, but last version I have is: {} . Current update should be dropped. id={}", new Object[]{cmd.prevVersion, lastFoundVersion, cmd.getPrintableId()});
            }
            return -1L;
        }
        if (Math.abs(lastFoundVersion) == cmd.prevVersion) {
            assert (0L < lastFoundVersion) : "prevVersion " + cmd.prevVersion + " found but is a delete!";
            if (log.isDebugEnabled()) {
                log.debug("Dependent update found. id={}", (Object)cmd.getPrintableId());
            }
            return lastFoundVersion;
        }
        if (log.isInfoEnabled()) {
            log.info("Missing update, on which current in-place update depends on, hasn't arrived. id={}, looking for version={}, last found version={}", new Object[]{cmd.getPrintableId(), cmd.prevVersion, lastFoundVersion});
        }
        if ((missingUpdate = this.fetchFullUpdateFromLeader(cmd, versionOnUpdate)) instanceof DeleteUpdateCommand) {
            if (log.isInfoEnabled()) {
                log.info("Tried to fetch document {} from the leader, but the leader says document has been deleted. Deleting the document here and skipping this update: Last found version: {}, was looking for: {}", new Object[]{cmd.getPrintableId(), lastFoundVersion, cmd.prevVersion});
            }
            this.versionDelete((DeleteUpdateCommand)missingUpdate);
            return -1L;
        }
        assert (missingUpdate instanceof AddUpdateCommand);
        if (log.isDebugEnabled()) {
            log.debug("Fetched the document: {}", (Object)((AddUpdateCommand)missingUpdate).getSolrInputDocument());
        }
        this.versionAdd((AddUpdateCommand)missingUpdate);
        if (log.isInfoEnabled()) {
            log.info("Added the fetched document, id= {}, version={}", (Object)((AddUpdateCommand)missingUpdate).getPrintableId(), (Object)missingUpdate.getVersion());
        }
        return missingUpdate.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doWaitForDependentUpdates(AddUpdateCommand cmd, long versionOnUpdate, boolean isReplayOrPeersync, VersionBucket bucket, TimeOut waitTimeout) {
        long lastFoundVersion;
        try {
            Long lookedUpVersion = this.vinfo.lookupVersion(cmd.getIndexedId());
            long l = lastFoundVersion = lookedUpVersion == null ? 0L : lookedUpVersion;
            if (Math.abs(lastFoundVersion) < cmd.prevVersion && log.isDebugEnabled()) {
                log.debug("Re-ordered inplace update. version={}, prevVersion={}, lastVersion={}, replayOrPeerSync={}, id={}", new Object[]{cmd.getVersion() == 0L ? versionOnUpdate : cmd.getVersion(), cmd.prevVersion, lastFoundVersion, isReplayOrPeersync, cmd.getPrintableId()});
            }
            while (Math.abs(lastFoundVersion) < cmd.prevVersion && !waitTimeout.hasTimedOut()) {
                long timeLeftInNanos = waitTimeout.timeLeft(TimeUnit.NANOSECONDS);
                if (timeLeftInNanos > 0L) {
                    bucket.awaitNanos(timeLeftInNanos);
                }
                lastFoundVersion = (lookedUpVersion = this.vinfo.lookupVersion(cmd.getIndexedId())) == null ? 0L : lookedUpVersion;
            }
        }
        finally {
            bucket.unlock();
        }
        return lastFoundVersion;
    }

    private UpdateCommand fetchFullUpdateFromLeader(AddUpdateCommand inplaceAdd, long versionOnUpdate) throws IOException {
        NamedList rsp;
        String id = inplaceAdd.getPrintableId();
        UpdateShardHandler updateShardHandler = inplaceAdd.getReq().getCore().getCoreContainer().getUpdateShardHandler();
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("distrib", false);
        params.set("getInputDocument", new String[]{id});
        params.set("onlyIfActive", true);
        GenericSolrRequest ur = new GenericSolrRequest(SolrRequest.METHOD.GET, "/get", (SolrParams)params);
        String leaderUrl = this.getLeaderUrl(id);
        if (leaderUrl == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can't find document with id=" + id);
        }
        try {
            ur.setBasePath(leaderUrl);
            rsp = updateShardHandler.getUpdateOnlyHttpClient().request((SolrRequest)ur);
        }
        catch (SolrServerException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error during fetching [" + id + "] from leader (" + leaderUrl + "): ", (Throwable)e);
        }
        Object inputDocObj = rsp.get("inputDocument");
        Long version = (Long)rsp.get("version");
        SolrInputDocument leaderDoc = (SolrInputDocument)inputDocObj;
        if (leaderDoc == null) {
            DeleteUpdateCommand del = new DeleteUpdateCommand(inplaceAdd.getReq());
            del.setIndexedId(inplaceAdd.getIndexedId());
            del.setId(inplaceAdd.getIndexedId().utf8ToString());
            del.setVersion(version == null || version == 0L ? -versionOnUpdate : version);
            return del;
        }
        AddUpdateCommand cmd = new AddUpdateCommand(this.req);
        cmd.solrDoc = leaderDoc;
        cmd.setVersion((Long)leaderDoc.getFieldValue("_version_"));
        return cmd;
    }

    boolean getUpdatedDocument(AddUpdateCommand cmd, long versionOnUpdate) throws IOException {
        SolrInputDocument mergedDoc;
        if (!AtomicUpdateDocumentMerger.isAtomicUpdate(cmd)) {
            return false;
        }
        Set<String> inPlaceUpdatedFields = AtomicUpdateDocumentMerger.computeInPlaceUpdatableFields(cmd);
        if (inPlaceUpdatedFields.size() > 0 && this.docMerger.doInPlaceUpdateMerge(cmd, inPlaceUpdatedFields)) {
            return true;
        }
        SolrInputDocument sdoc = cmd.getSolrInputDocument();
        BytesRef idBytes = cmd.getIndexedId();
        String idString = cmd.getPrintableId();
        SolrInputDocument oldRootDocWithChildren = RealTimeGetComponent.getInputDocument(cmd.getReq().getCore(), idBytes, RealTimeGetComponent.Resolution.ROOT_WITH_CHILDREN);
        if (oldRootDocWithChildren == null) {
            if (versionOnUpdate > 0L) {
                throw new SolrException(SolrException.ErrorCode.CONFLICT, "Document not found for update.  id=" + idString);
            }
            if (this.req.getParams().get("_route_") != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not find document id=" + idString + ", perhaps the wrong \"_route_\" param was supplied");
            }
        } else {
            oldRootDocWithChildren.remove((Object)"_version_");
        }
        if (this.idField == null || oldRootDocWithChildren == null) {
            mergedDoc = this.docMerger.merge(sdoc, new SolrInputDocument(new String[0]));
        } else {
            if (this.req.getSchema().isUsableForChildDocs() && !this.req.getSchema().supportsPartialUpdatesOfChildDocs() && this.req.getSearcher().count((Query)new TermQuery(new Term("_root_", idBytes))) > 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "This schema does not support partial updates to nested docs. See ref guide.");
            }
            String oldRootDocRootFieldVal = (String)oldRootDocWithChildren.getFieldValue("_root_");
            if (this.req.getSchema().savesChildDocRelations() && oldRootDocRootFieldVal != null && !idString.equals(oldRootDocRootFieldVal)) {
                SolrInputDocument sdocWithChildren = RealTimeGetComponent.getInputDocument(cmd.getReq().getCore(), idBytes, RealTimeGetComponent.Resolution.DOC_WITH_CHILDREN);
                mergedDoc = this.docMerger.mergeChildDoc(sdoc, oldRootDocWithChildren, sdocWithChildren);
            } else {
                mergedDoc = this.docMerger.merge(sdoc, oldRootDocWithChildren);
            }
        }
        cmd.solrDoc = mergedDoc;
        return true;
    }

    @Override
    public void processDelete(DeleteUpdateCommand cmd) throws IOException {
        assert (TestInjection.injectFailUpdateRequests());
        this.updateCommand = cmd;
        if (!cmd.isDeleteById()) {
            this.doDeleteByQuery(cmd);
        } else {
            this.doDeleteById(cmd);
        }
    }

    protected void doDeleteById(DeleteUpdateCommand cmd) throws IOException {
        this.setupRequest(cmd);
        boolean dropCmd = false;
        if (!this.forwardToLeader) {
            dropCmd = this.versionDelete(cmd);
        }
        if (dropCmd) {
            return;
        }
        this.doDistribDeleteById(cmd);
        if (this.returnVersions && this.rsp != null && cmd.getIndexedId() != null && this.idField != null) {
            if (this.deleteResponse == null) {
                this.deleteResponse = new NamedList(1);
                this.rsp.add("deletes", this.deleteResponse);
            }
            if (this.scratch == null) {
                this.scratch = new CharsRefBuilder();
            }
            this.idField.getType().indexedToReadable(cmd.getIndexedId(), this.scratch);
            this.deleteResponse.add(this.scratch.toString(), (Object)cmd.getVersion());
        }
    }

    protected void doDistribDeleteById(DeleteUpdateCommand cmd) throws IOException {
    }

    protected ModifiableSolrParams filterParams(SolrParams params) {
        ModifiableSolrParams fparams = new ModifiableSolrParams();
        Set whitelist = (Set)this.req.getContext().get(PARAM_WHITELIST_CTX_KEY);
        assert (null != whitelist) : "whitelist can't be null, constructor adds to it";
        for (String p : whitelist) {
            this.passParam(params, fparams, p);
        }
        return fparams;
    }

    private void passParam(SolrParams params, ModifiableSolrParams fparams, String param) {
        String[] values = params.getParams(param);
        if (values != null) {
            for (String value : values) {
                fparams.add(param, new String[]{value});
            }
        }
    }

    protected void doDeleteByQuery(DeleteUpdateCommand cmd) throws IOException {
        this.setupRequest(cmd);
        this.doDeleteByQuery(cmd, null, null);
    }

    protected void doDeleteByQuery(DeleteUpdateCommand cmd, List<SolrCmdDistributor.Node> replicas, DocCollection coll) throws IOException {
        if (this.vinfo == null) {
            super.processDelete(cmd);
            return;
        }
        this.versionDeleteByQuery(cmd);
        this.doDistribDeleteByQuery(cmd, replicas, coll);
        if (this.returnVersions && this.rsp != null) {
            if (this.deleteByQueryResponse == null) {
                this.deleteByQueryResponse = new NamedList(1);
                this.rsp.add("deleteByQuery", this.deleteByQueryResponse);
            }
            this.deleteByQueryResponse.add(cmd.getQuery(), (Object)cmd.getVersion());
        }
    }

    protected void doDistribDeleteByQuery(DeleteUpdateCommand cmd, List<SolrCmdDistributor.Node> replicas, DocCollection coll) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void versionDeleteByQuery(DeleteUpdateCommand cmd) throws IOException {
        boolean leaderLogic;
        long versionOnUpdate = this.findVersionOnUpdate(cmd);
        boolean isReplayOrPeersync = (cmd.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0;
        boolean bl = leaderLogic = this.isLeader && !isReplayOrPeersync;
        if (!leaderLogic && versionOnUpdate == 0L) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing _version_ on update from leader");
        }
        this.vinfo.blockUpdates();
        try {
            this.doLocalDeleteByQuery(cmd, versionOnUpdate, isReplayOrPeersync);
        }
        finally {
            this.vinfo.unblockUpdates();
        }
    }

    private long findVersionOnUpdate(UpdateCommand cmd) {
        long versionOnUpdate = cmd.getVersion();
        if (versionOnUpdate == 0L) {
            String versionOnUpdateS = this.req.getParams().get("_version_");
            versionOnUpdate = versionOnUpdateS == null ? 0L : Long.parseLong(versionOnUpdateS);
        }
        versionOnUpdate = Math.abs(versionOnUpdate);
        return versionOnUpdate;
    }

    private void doLocalDeleteByQuery(DeleteUpdateCommand cmd, long versionOnUpdate, boolean isReplayOrPeersync) throws IOException {
        if (this.versionsStored) {
            boolean leaderLogic = this.isLeader & !isReplayOrPeersync;
            if (leaderLogic) {
                long version = this.vinfo.getNewClock();
                cmd.setVersion(-version);
                this.doLocalDelete(cmd);
            } else {
                cmd.setVersion(-versionOnUpdate);
                if (this.ulog.getState() != UpdateLog.State.ACTIVE && !isReplayOrPeersync) {
                    cmd.setFlags(cmd.getFlags() | UpdateCommand.BUFFERING);
                    this.ulog.deleteByQuery(cmd);
                    return;
                }
                if (!this.isSubShardLeader && this.replicaType == Replica.Type.TLOG && (cmd.getFlags() & UpdateCommand.REPLAY) == 0) {
                    cmd.setFlags(cmd.getFlags() | UpdateCommand.IGNORE_INDEXWRITER);
                }
                this.doLocalDelete(cmd);
            }
        }
    }

    void setupRequest(UpdateCommand cmd) {
        this.updateCommand = cmd;
        this.isLeader = DistributedUpdateProcessor.getNonZkLeaderAssumption(this.req);
    }

    protected String getLeaderUrl(String id) {
        return this.req.getParams().get(DISTRIB_FROM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean versionDelete(DeleteUpdateCommand cmd) throws IOException {
        boolean forwardedFromCollection;
        BytesRef idBytes = cmd.getIndexedId();
        if (this.vinfo == null || idBytes == null) {
            super.processDelete(cmd);
            return false;
        }
        int bucketHash = DistributedUpdateProcessor.bucketHash(idBytes);
        long versionOnUpdate = cmd.getVersion();
        if (versionOnUpdate == 0L) {
            String versionOnUpdateS = this.req.getParams().get("_version_");
            versionOnUpdate = versionOnUpdateS == null ? 0L : Long.parseLong(versionOnUpdateS);
        }
        long signedVersionOnUpdate = versionOnUpdate;
        versionOnUpdate = Math.abs(versionOnUpdate);
        boolean isReplayOrPeersync = (cmd.getFlags() & (UpdateCommand.REPLAY | UpdateCommand.PEER_SYNC)) != 0;
        boolean leaderLogic = this.isLeader && !isReplayOrPeersync;
        boolean bl = forwardedFromCollection = cmd.getReq().getParams().get(DISTRIB_FROM_COLLECTION) != null;
        if (!leaderLogic && versionOnUpdate == 0L) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing _version_ on update from leader");
        }
        VersionBucket bucket = this.vinfo.bucket(bucketHash);
        this.vinfo.lockForUpdate();
        try {
            long finalVersionOnUpdate = versionOnUpdate;
            boolean bl2 = bucket.runWithLock(this.vinfo.getVersionBucketLockTimeoutMs(), () -> this.doVersionDelete(cmd, finalVersionOnUpdate, signedVersionOnUpdate, isReplayOrPeersync, leaderLogic, forwardedFromCollection, bucket));
            return bl2;
        }
        finally {
            this.vinfo.unlockForUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doVersionDelete(DeleteUpdateCommand cmd, long versionOnUpdate, long signedVersionOnUpdate, boolean isReplayOrPeersync, boolean leaderLogic, boolean forwardedFromCollection, VersionBucket bucket) throws IOException {
        try {
            BytesRef idBytes = cmd.getIndexedId();
            if (this.versionsStored) {
                long bucketVersion = bucket.highest;
                if (leaderLogic) {
                    if (forwardedFromCollection && this.ulog.getState() == UpdateLog.State.ACTIVE) {
                        if (log.isInfoEnabled()) {
                            log.info("Removing version field from doc: {}", (Object)cmd.getId());
                        }
                        signedVersionOnUpdate = 0L;
                        versionOnUpdate = 0L;
                    }
                    if (forwardedFromCollection && this.ulog.getState() != UpdateLog.State.ACTIVE && !isReplayOrPeersync) {
                        if (log.isInfoEnabled()) {
                            log.info("Leader logic applied but update log is buffering: {}", (Object)cmd.getId());
                        }
                        cmd.setFlags(cmd.getFlags() | UpdateCommand.BUFFERING);
                        this.ulog.delete(cmd);
                        boolean bl = true;
                        return bl;
                    }
                    if (signedVersionOnUpdate != 0L) {
                        long foundVersion;
                        Long lastVersion = this.vinfo.lookupVersion(cmd.getIndexedId());
                        long l = foundVersion = lastVersion == null ? -1L : lastVersion;
                        if (!(signedVersionOnUpdate == foundVersion || signedVersionOnUpdate < 0L && foundVersion < 0L || signedVersionOnUpdate == 1L && foundVersion > 0L)) {
                            throw new SolrException(SolrException.ErrorCode.CONFLICT, "version conflict for " + cmd.getId() + " expected=" + signedVersionOnUpdate + " actual=" + foundVersion);
                        }
                    }
                    long version = this.vinfo.getNewClock();
                    cmd.setVersion(-version);
                    bucket.updateHighest(version);
                } else {
                    cmd.setVersion(-versionOnUpdate);
                    if (this.ulog.getState() != UpdateLog.State.ACTIVE && !isReplayOrPeersync) {
                        cmd.setFlags(cmd.getFlags() | UpdateCommand.BUFFERING);
                        this.ulog.delete(cmd);
                        boolean version = true;
                        return version;
                    }
                    if (bucketVersion != 0L && bucketVersion < versionOnUpdate) {
                        bucket.updateHighest(versionOnUpdate);
                    } else {
                        Long lastVersion = this.vinfo.lookupVersion(cmd.getIndexedId());
                        if (lastVersion != null && Math.abs(lastVersion) >= versionOnUpdate) {
                            if (log.isDebugEnabled()) {
                                log.debug("Dropping delete update due to version {}", (Object)idBytes.utf8ToString());
                            }
                            boolean bl = true;
                            return bl;
                        }
                    }
                    if (!this.isSubShardLeader && this.replicaType == Replica.Type.TLOG && (cmd.getFlags() & UpdateCommand.REPLAY) == 0) {
                        cmd.setFlags(cmd.getFlags() | UpdateCommand.IGNORE_INDEXWRITER);
                    }
                }
            }
            this.doLocalDelete(cmd);
            boolean bl = false;
            return bl;
        }
        finally {
            bucket.unlock();
        }
    }

    @Override
    public void processCommit(CommitUpdateCommand cmd) throws IOException {
        assert (TestInjection.injectFailUpdateRequests());
        this.updateCommand = cmd;
        this.doLocalCommit(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLocalCommit(CommitUpdateCommand cmd) throws IOException {
        if (this.vinfo != null) {
            long commitVersion = this.vinfo.getNewClock();
            cmd.setVersion(commitVersion);
            this.vinfo.lockForUpdate();
        }
        try {
            if (this.ulog == null || this.ulog.getState() == UpdateLog.State.ACTIVE || (cmd.getFlags() & UpdateCommand.REPLAY) != 0) {
                super.processCommit(cmd);
            } else if (log.isInfoEnabled()) {
                log.info("Ignoring commit while not ACTIVE - state: {} replay: {}", (Object)this.ulog.getState(), (Object)((cmd.getFlags() & UpdateCommand.REPLAY) != 0 ? 1 : 0));
            }
        }
        finally {
            if (this.vinfo != null) {
                this.vinfo.unlockForUpdate();
            }
        }
    }

    @Override
    public final void finish() throws IOException {
        assert (!this.finished) : "lifecycle sanity check";
        this.finished = true;
        this.doDistribFinish();
        super.finish();
    }

    protected void doDistribFinish() throws IOException {
    }

    private static boolean shouldRefreshUlogCaches(AddUpdateCommand cmd) {
        assert (!cmd.getReq().getSchema().savesChildDocRelations() || cmd.isNested != null);
        return Boolean.TRUE.equals(cmd.isNested);
    }

    public static boolean getNonZkLeaderAssumption(SolrQueryRequest req) {
        DistribPhase phase = DistribPhase.parseParam(req.getParams().get("update.distrib"));
        return DistribPhase.FROMLEADER != phase;
    }

    public static class LeaderRequestReplicationTracker {
        private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        private int achievedRf = 1;
        private final String myShardId;

        public LeaderRequestReplicationTracker(String shardId) {
            this.myShardId = shardId;
        }

        public int getAchievedRf() {
            return this.achievedRf;
        }

        public void trackRequestResult(SolrCmdDistributor.Node node, boolean success) {
            if (log.isDebugEnabled()) {
                log.debug("trackRequestResult({}): success? {}, shardId={}", new Object[]{node, success, this.myShardId});
            }
            if (success) {
                ++this.achievedRf;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("LeaderRequestReplicationTracker");
            sb.append(", achievedRf=").append(this.getAchievedRf()).append(" for shard ").append(this.myShardId);
            return sb.toString();
        }
    }

    public static class RollupRequestReplicationTracker {
        private int achievedRf = Integer.MAX_VALUE;

        public int getAchievedRf() {
            return this.achievedRf;
        }

        public void testAndSetAchievedRf(int rf) {
            this.achievedRf = Math.min(this.achievedRf, rf);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("RollupRequestReplicationTracker").append(" achievedRf: ").append(this.achievedRf);
            return sb.toString();
        }
    }

    public static final class DistributedUpdatesAsyncException
    extends SolrException {
        public final List<SolrCmdDistributor.Error> errors;

        public DistributedUpdatesAsyncException(List<SolrCmdDistributor.Error> errors) {
            super(DistributedUpdatesAsyncException.buildCode(errors), DistributedUpdatesAsyncException.buildMsg(errors), null);
            this.errors = errors;
            NamedList metadata = new NamedList();
            for (SolrCmdDistributor.Error error : errors) {
                SolrException e;
                NamedList eMeta;
                if (!(error.e instanceof SolrException) || null == (eMeta = (e = (SolrException)((Object)error.e)).getMetadata())) continue;
                metadata.addAll(eMeta);
            }
            if (0 < metadata.size()) {
                this.setMetadata(metadata);
            }
        }

        private static int buildCode(List<SolrCmdDistributor.Error> errors) {
            assert (null != errors);
            assert (0 < errors.size());
            int minCode = Integer.MAX_VALUE;
            int maxCode = Integer.MIN_VALUE;
            for (SolrCmdDistributor.Error error : errors) {
                log.trace("REMOTE ERROR: {}", (Object)error);
                minCode = Math.min(error.statusCode, minCode);
                maxCode = Math.max(error.statusCode, maxCode);
            }
            if (minCode == maxCode) {
                return minCode;
            }
            if (400 <= minCode && maxCode < 500) {
                return SolrException.ErrorCode.BAD_REQUEST.code;
            }
            return SolrException.ErrorCode.SERVER_ERROR.code;
        }

        private static String buildMsg(List<SolrCmdDistributor.Error> errors) {
            assert (null != errors);
            assert (0 < errors.size());
            if (1 == errors.size()) {
                return "Async exception during distributed update: " + errors.get((int)0).e.getMessage();
            }
            StringBuilder buf = new StringBuilder(errors.size() + " Async exceptions during distributed update: ");
            for (SolrCmdDistributor.Error error : errors) {
                buf.append("\n");
                buf.append(error.e.getMessage());
            }
            return buf.toString();
        }
    }

    public static enum DistribPhase {
        NONE,
        TOLEADER,
        FROMLEADER;


        public static DistribPhase parseParam(String param) {
            if (param == null || param.trim().isEmpty()) {
                return NONE;
            }
            try {
                return DistribPhase.valueOf(param);
            }
            catch (IllegalArgumentException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Illegal value for update.distrib: " + param, (Throwable)e);
            }
        }
    }
}

