/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.serializers.AsciiSerializer;
import com.netflix.astyanax.serializers.BigDecimalSerializer;
import com.netflix.astyanax.serializers.BigIntegerSerializer;
import com.netflix.astyanax.serializers.BooleanSerializer;
import com.netflix.astyanax.serializers.ByteBufferSerializer;
import com.netflix.astyanax.serializers.CompositeSerializer;
import com.netflix.astyanax.serializers.DateSerializer;
import com.netflix.astyanax.serializers.DoubleSerializer;
import com.netflix.astyanax.serializers.DynamicCompositeSerializer;
import com.netflix.astyanax.serializers.FloatSerializer;
import com.netflix.astyanax.serializers.Int32Serializer;
import com.netflix.astyanax.serializers.LongSerializer;
import com.netflix.astyanax.serializers.ReversedSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.serializers.TimeUUIDSerializer;
import com.netflix.astyanax.serializers.UUIDSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.ShadedTypeParser;

public enum ComparatorType {
    ASCIITYPE("com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AsciiType", AsciiSerializer.get()),
    BYTESTYPE("com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.BytesType", ByteBufferSerializer.get()),
    INTEGERTYPE("com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.IntegerType", BigIntegerSerializer.get()),
    INT32TYPE("com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.Int32Type", Int32Serializer.get()),
    DECIMALTYPE("com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.DecimalType", BigDecimalSerializer.get()),
    LEXICALUUIDTYPE("com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.LexicalUUIDType", UUIDSerializer.get()),
    LOCALBYPARTITIONERTYPE("com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.LocalByPartionerType", ByteBufferSerializer.get()),
    LONGTYPE("com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.LongType", LongSerializer.get()),
    TIMEUUIDTYPE("com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.TimeUUIDType", TimeUUIDSerializer.get()),
    UTF8TYPE("com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.UTF8Type", StringSerializer.get()),
    COMPOSITETYPE("com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.CompositeType", CompositeSerializer.get()),
    DYNAMICCOMPOSITETYPE("com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.DynamicCompositeType", DynamicCompositeSerializer.get()),
    UUIDTYPE("com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.UUIDType", UUIDSerializer.get()),
    COUNTERTYPE("com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.CounterColumnType", LongSerializer.get()),
    DOUBLETYPE("com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.DoubleType", DoubleSerializer.get()),
    FLOATTYPE("com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.FloatType", FloatSerializer.get()),
    BOOLEANTYPE("com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.BooleanType", BooleanSerializer.get()),
    DATETYPE("com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.DateType", DateSerializer.get()),
    REVERSEDTYPE("com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.ReversedType", ReversedSerializer.get());

    private final String className;
    private final String typeName;
    private final Serializer<?> serializer;

    private ComparatorType(String className, Serializer<?> serializer) {
        this.className = className;
        this.typeName = ComparatorType.getShadedTypeName(className);
        this.serializer = serializer;
    }

    public String getClassName() {
        return this.className;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Serializer<?> getSerializer() {
        return this.serializer;
    }

    public static ComparatorType getByClassName(String className) {
        if (className == null) {
            return null;
        }
        for (ComparatorType type : ComparatorType.values()) {
            if (!type.getClassName().equals(ComparatorType.getShadedClassName(className))) continue;
            return type;
        }
        return null;
    }

    public static String getShadedClassName(String className) {
        return ShadedTypeParser.getShadedClassName(className);
    }

    public static String getShadedTypeName(String typeName) {
        return ShadedTypeParser.getShadedTypeName(typeName);
    }
}

