/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.netflix.astyanax.serializers.AbstractSerializer;
import com.netflix.astyanax.serializers.ComparatorType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.LongType;
import java.nio.ByteBuffer;

public final class LongSerializer
extends AbstractSerializer<Long> {
    private static final LongSerializer instance = new LongSerializer();

    public static LongSerializer get() {
        return instance;
    }

    @Override
    public ByteBuffer toByteBuffer(Long obj) {
        if (obj == null) {
            return null;
        }
        return ByteBuffer.allocate(8).putLong(0, obj);
    }

    @Override
    public Long fromByteBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        ByteBuffer dup = byteBuffer.duplicate();
        if (dup.remaining() == 8) {
            long l = dup.getLong();
            return l;
        }
        if (dup.remaining() == 4) {
            return dup.getInt();
        }
        return null;
    }

    @Override
    public ComparatorType getComparatorType() {
        return ComparatorType.LONGTYPE;
    }

    @Override
    public ByteBuffer fromString(String str) {
        return LongType.instance.fromString(str);
    }

    @Override
    public String getString(ByteBuffer byteBuffer) {
        return LongType.instance.getString(byteBuffer);
    }

    @Override
    public ByteBuffer getNext(ByteBuffer byteBuffer) {
        Long val = this.fromByteBuffer(byteBuffer.duplicate());
        if (val == Long.MAX_VALUE) {
            throw new ArithmeticException("Can't paginate past max long");
        }
        return this.toByteBuffer(val + 1L);
    }
}

