/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.CFMetaData;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.QueryProcessor;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.ColumnGroupMap;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Column;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.CounterUpdateColumn;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DeletedColumn;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RangeTombstone;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.Pair;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class UpdateParameters {
    public final CFMetaData metadata;
    public final List<ByteBuffer> variables;
    public final long timestamp;
    private final int ttl;
    public final int localDeletionTime;
    private final Map<ByteBuffer, ColumnGroupMap> prefetchedLists;

    public UpdateParameters(CFMetaData metadata, List<ByteBuffer> variables, long timestamp, int ttl, Map<ByteBuffer, ColumnGroupMap> prefetchedLists) throws InvalidRequestException {
        this.metadata = metadata;
        this.variables = variables;
        this.timestamp = timestamp;
        this.ttl = ttl;
        this.localDeletionTime = (int)(System.currentTimeMillis() / 1000L);
        this.prefetchedLists = prefetchedLists;
        if (timestamp == Long.MIN_VALUE) {
            throw new InvalidRequestException(String.format("Out of bound timestamp, must be in [%d, %d]", -9223372036854775807L, Long.MAX_VALUE));
        }
    }

    public Column makeColumn(ByteBuffer name, ByteBuffer value) throws InvalidRequestException {
        QueryProcessor.validateCellName(name);
        return Column.create(name, value, this.timestamp, this.ttl, this.metadata);
    }

    public Column makeCounter(ByteBuffer name, long delta) throws InvalidRequestException {
        QueryProcessor.validateCellName(name);
        return new CounterUpdateColumn(name, delta, System.currentTimeMillis());
    }

    public Column makeTombstone(ByteBuffer name) throws InvalidRequestException {
        QueryProcessor.validateCellName(name);
        return new DeletedColumn(name, this.localDeletionTime, this.timestamp);
    }

    public RangeTombstone makeRangeTombstone(ByteBuffer start, ByteBuffer end) throws InvalidRequestException {
        QueryProcessor.validateCellName(start);
        QueryProcessor.validateCellName(end);
        return new RangeTombstone(start, end, this.timestamp, this.localDeletionTime);
    }

    public RangeTombstone makeTombstoneForOverwrite(ByteBuffer start, ByteBuffer end) throws InvalidRequestException {
        QueryProcessor.validateCellName(start);
        QueryProcessor.validateCellName(end);
        return new RangeTombstone(start, end, this.timestamp - 1L, this.localDeletionTime);
    }

    public List<Pair<ByteBuffer, Column>> getPrefetchedList(ByteBuffer rowKey, ByteBuffer cql3ColumnName) {
        if (this.prefetchedLists == null) {
            return Collections.emptyList();
        }
        ColumnGroupMap m = this.prefetchedLists.get(rowKey);
        return m == null ? Collections.emptyList() : m.getCollection(cql3ColumnName);
    }
}

