/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3.functions;

import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.functions.AbstractFunction;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.functions.Function;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.BytesType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.UTF8Type;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.MarshalException;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import java.nio.ByteBuffer;
import java.util.List;

public abstract class BytesConversionFcts {
    public static final Function VarcharAsBlobFct = new AbstractFunction("varcharasblob", (AbstractType)BytesType.instance, new AbstractType[]{UTF8Type.instance}){

        @Override
        public ByteBuffer execute(List<ByteBuffer> parameters) {
            return parameters.get(0);
        }
    };
    public static final Function BlobAsVarcharFact = new AbstractFunction("blobasvarchar", (AbstractType)UTF8Type.instance, new AbstractType[]{BytesType.instance}){

        @Override
        public ByteBuffer execute(List<ByteBuffer> parameters) {
            return parameters.get(0);
        }
    };

    public static Function makeToBlobFunction(AbstractType<?> fromType) {
        String name = fromType.asCQL3Type() + "asblob";
        return new AbstractFunction(name, (AbstractType)BytesType.instance, new AbstractType[]{fromType}){

            @Override
            public ByteBuffer execute(List<ByteBuffer> parameters) {
                return parameters.get(0);
            }
        };
    }

    public static Function makeFromBlobFunction(final AbstractType<?> toType) {
        String name = "blobas" + toType.asCQL3Type();
        return new AbstractFunction(name, (AbstractType)toType, new AbstractType[]{BytesType.instance}){

            @Override
            public ByteBuffer execute(List<ByteBuffer> parameters) throws InvalidRequestException {
                ByteBuffer val = parameters.get(0);
                try {
                    if (val != null) {
                        toType.validate(val);
                    }
                    return val;
                }
                catch (MarshalException e) {
                    throw new InvalidRequestException(String.format("In call to function %s, value 0x%s is not a valid binary representation for type %s", this.name, ByteBufferUtil.bytesToHex(val), toType.asCQL3Type()));
                }
            }
        };
    }
}

