/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.CFMetaData;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Column;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RangeTombstone;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.ISSTableSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable.Descriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.MarshalException;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;

public interface OnDiskAtom {
    public ByteBuffer name();

    public long minTimestamp();

    public long maxTimestamp();

    public int getLocalDeletionTime();

    public int serializedSize(TypeSizes var1);

    public long serializedSizeForSSTable();

    public void validateFields(CFMetaData var1) throws MarshalException;

    public void updateDigest(MessageDigest var1);

    public static class Serializer
    implements ISSTableSerializer<OnDiskAtom> {
        public static Serializer instance = new Serializer();

        private Serializer() {
        }

        @Override
        public void serializeForSSTable(OnDiskAtom atom, DataOutput out) throws IOException {
            if (atom instanceof Column) {
                Column.serializer.serialize((Column)atom, out);
            } else {
                assert (atom instanceof RangeTombstone);
                RangeTombstone.serializer.serializeForSSTable((RangeTombstone)atom, out);
            }
        }

        @Override
        public OnDiskAtom deserializeFromSSTable(DataInput in, Descriptor.Version version) throws IOException {
            return this.deserializeFromSSTable(in, ColumnSerializer.Flag.LOCAL, Integer.MIN_VALUE, version);
        }

        public OnDiskAtom deserializeFromSSTable(DataInput in, ColumnSerializer.Flag flag, int expireBefore, Descriptor.Version version) throws IOException {
            ByteBuffer name = ByteBufferUtil.readWithShortLength(in);
            if (name.remaining() <= 0) {
                return null;
            }
            int b = in.readUnsignedByte();
            if ((b & 0x10) != 0) {
                return RangeTombstone.serializer.deserializeBody(in, name, version);
            }
            return Column.serializer.deserializeColumnBody(in, name, b, flag, expireBefore);
        }
    }
}

