/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.AbstractRangeCommand;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamilyStore;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Keyspace;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RangeSliceCommandSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Row;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RowPosition;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.ExtendedFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.IDiskAtomFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.dht.AbstractBounds;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessageOut;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessagingService;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.pager.Pageable;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.IndexExpression;
import java.util.List;

public class RangeSliceCommand
extends AbstractRangeCommand
implements Pageable {
    public static final RangeSliceCommandSerializer serializer = new RangeSliceCommandSerializer();
    public final int maxResults;
    public final boolean countCQL3Rows;
    public final boolean isPaging;

    public RangeSliceCommand(String keyspace, String column_family, long timestamp, IDiskAtomFilter predicate, AbstractBounds<RowPosition> range, int maxResults) {
        this(keyspace, column_family, timestamp, predicate, range, null, maxResults, false, false);
    }

    public RangeSliceCommand(String keyspace, String column_family, long timestamp, IDiskAtomFilter predicate, AbstractBounds<RowPosition> range, List<IndexExpression> row_filter, int maxResults) {
        this(keyspace, column_family, timestamp, predicate, range, row_filter, maxResults, false, false);
    }

    public RangeSliceCommand(String keyspace, String column_family, long timestamp, IDiskAtomFilter predicate, AbstractBounds<RowPosition> range, List<IndexExpression> row_filter, int maxResults, boolean countCQL3Rows, boolean isPaging) {
        super(keyspace, column_family, timestamp, range, predicate, row_filter);
        this.maxResults = maxResults;
        this.countCQL3Rows = countCQL3Rows;
        this.isPaging = isPaging;
    }

    public MessageOut<RangeSliceCommand> createMessage() {
        return new MessageOut<RangeSliceCommand>(MessagingService.Verb.RANGE_SLICE, this, serializer);
    }

    @Override
    public AbstractRangeCommand forSubRange(AbstractBounds<RowPosition> subRange) {
        return new RangeSliceCommand(this.keyspace, this.columnFamily, this.timestamp, this.predicate.cloneShallow(), subRange, this.rowFilter, this.maxResults, this.countCQL3Rows, this.isPaging);
    }

    @Override
    public AbstractRangeCommand withUpdatedLimit(int newLimit) {
        return new RangeSliceCommand(this.keyspace, this.columnFamily, this.timestamp, this.predicate.cloneShallow(), this.keyRange, this.rowFilter, newLimit, this.countCQL3Rows, this.isPaging);
    }

    @Override
    public int limit() {
        return this.maxResults;
    }

    @Override
    public boolean countCQL3Rows() {
        return this.countCQL3Rows;
    }

    @Override
    public List<Row> executeLocally() {
        ColumnFamilyStore cfs = Keyspace.open(this.keyspace).getColumnFamilyStore(this.columnFamily);
        ExtendedFilter exFilter = cfs.makeExtendedFilter(this.keyRange, this.predicate, this.rowFilter, this.maxResults, this.countCQL3Rows, this.isPaging, this.timestamp);
        if (cfs.indexManager.hasIndexFor(this.rowFilter)) {
            return cfs.search(exFilter);
        }
        return cfs.getRangeSlice(exFilter);
    }

    public String toString() {
        return "RangeSliceCommand{keyspace='" + this.keyspace + '\'' + ", columnFamily='" + this.columnFamily + '\'' + ", timestamp=" + this.timestamp + ", predicate=" + this.predicate + ", range=" + this.keyRange + ", rowFilter =" + this.rowFilter + ", maxResults=" + this.maxResults + ", countCQL3Rows=" + this.countCQL3Rows + "}";
    }
}

