/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.CFMetaData;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.Schema;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamilyType;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ReadCommand;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.SliceByNamesReadCommand;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.SliceFromReadCommand;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.SuperColumns;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.CompositeType;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.IVersionedSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

class ReadCommandSerializer
implements IVersionedSerializer<ReadCommand> {
    ReadCommandSerializer() {
    }

    @Override
    public void serialize(ReadCommand command, DataOutput out, int version) throws IOException {
        ReadCommand newCommand = command;
        ByteBuffer superColumn = null;
        if (version < 7) {
            CFMetaData metadata = Schema.instance.getCFMetaData(command.ksName, command.cfName);
            if (metadata.cfType == ColumnFamilyType.Super) {
                SuperColumns.SCFilter scFilter = SuperColumns.filterToSC((CompositeType)metadata.comparator, command.filter());
                newCommand = ReadCommand.create(command.ksName, command.key, command.cfName, command.timestamp, scFilter.updatedFilter);
                newCommand.setDigestQuery(command.isDigestQuery());
                superColumn = scFilter.scName;
            }
        }
        out.writeByte(newCommand.commandType.serializedValue);
        switch (command.commandType) {
            case GET_BY_NAMES: {
                SliceByNamesReadCommand.serializer.serialize(newCommand, superColumn, out, version);
                break;
            }
            case GET_SLICES: {
                SliceFromReadCommand.serializer.serialize(newCommand, superColumn, out, version);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @Override
    public ReadCommand deserialize(DataInput in, int version) throws IOException {
        ReadCommand.Type msgType = ReadCommand.Type.fromSerializedValue(in.readByte());
        switch (msgType) {
            case GET_BY_NAMES: {
                return SliceByNamesReadCommand.serializer.deserialize(in, version);
            }
            case GET_SLICES: {
                return SliceFromReadCommand.serializer.deserialize(in, version);
            }
        }
        throw new AssertionError();
    }

    @Override
    public long serializedSize(ReadCommand command, int version) {
        ReadCommand newCommand = command;
        ByteBuffer superColumn = null;
        if (version < 7) {
            CFMetaData metadata = Schema.instance.getCFMetaData(command.ksName, command.cfName);
            if (metadata.cfType == ColumnFamilyType.Super) {
                SuperColumns.SCFilter scFilter = SuperColumns.filterToSC((CompositeType)metadata.comparator, command.filter());
                newCommand = ReadCommand.create(command.ksName, command.key, command.cfName, command.timestamp, scFilter.updatedFilter);
                newCommand.setDigestQuery(command.isDigestQuery());
                superColumn = scFilter.scName;
            }
        }
        switch (command.commandType) {
            case GET_BY_NAMES: {
                return 1L + SliceByNamesReadCommand.serializer.serializedSize(newCommand, superColumn, version);
            }
            case GET_SLICES: {
                return 1L + SliceFromReadCommand.serializer.serializedSize(newCommand, superColumn, version);
            }
        }
        throw new AssertionError();
    }
}

