/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.columniterator;

import com.google.common.collect.AbstractIterator;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.CFMetaData;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ArrayBackedSortedColumns;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Column;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamily;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamilySerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DecoratedKey;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DeletionTime;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.OnDiskAtom;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RowIndexEntry;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.columniterator.IndexedSliceReader;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable.CorruptSSTableException;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable.IndexHelper;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable.SSTableReader;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.FileDataInput;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.FileMark;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.FileUtils;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

public class SSTableNamesIterator
extends AbstractIterator<OnDiskAtom>
implements OnDiskAtomIterator {
    private ColumnFamily cf;
    private final SSTableReader sstable;
    private FileDataInput fileToClose;
    private Iterator<OnDiskAtom> iter;
    public final SortedSet<ByteBuffer> columns;
    public final DecoratedKey key;

    public SSTableNamesIterator(SSTableReader sstable, DecoratedKey key, SortedSet<ByteBuffer> columns) {
        assert (columns != null);
        this.sstable = sstable;
        this.columns = columns;
        this.key = key;
        RowIndexEntry indexEntry = sstable.getPosition(key, SSTableReader.Operator.EQ);
        if (indexEntry == null) {
            return;
        }
        try {
            this.read(sstable, null, indexEntry);
        }
        catch (IOException e) {
            sstable.markSuspect();
            throw new CorruptSSTableException((Exception)e, sstable.getFilename());
        }
        finally {
            if (this.fileToClose != null) {
                FileUtils.closeQuietly(this.fileToClose);
            }
        }
    }

    public SSTableNamesIterator(SSTableReader sstable, FileDataInput file, DecoratedKey key, SortedSet<ByteBuffer> columns, RowIndexEntry indexEntry) {
        assert (columns != null);
        this.sstable = sstable;
        this.columns = columns;
        this.key = key;
        try {
            this.read(sstable, file, indexEntry);
        }
        catch (IOException e) {
            sstable.markSuspect();
            throw new CorruptSSTableException((Exception)e, sstable.getFilename());
        }
    }

    private FileDataInput createFileDataInput(long position) {
        this.fileToClose = this.sstable.getFileDataInput(position);
        return this.fileToClose;
    }

    private void read(SSTableReader sstable, FileDataInput file, RowIndexEntry indexEntry) throws IOException {
        if (!indexEntry.isIndexed()) {
            if (file == null) {
                file = this.createFileDataInput(indexEntry.position);
            } else {
                file.seek(indexEntry.position);
            }
            DecoratedKey keyInDisk = sstable.partitioner.decorateKey(ByteBufferUtil.readWithShortLength(file));
            assert (keyInDisk.equals(this.key)) : String.format("%s != %s in %s", keyInDisk, this.key, file.getPath());
            if (sstable.descriptor.version.hasRowSizeAndColumnCount) {
                file.readLong();
            }
        }
        List<IndexHelper.IndexInfo> indexList = indexEntry.columnsIndex();
        if (!indexEntry.isIndexed()) {
            ColumnFamilySerializer serializer = ColumnFamily.serializer;
            try {
                this.cf = ArrayBackedSortedColumns.factory.create(sstable.metadata);
                this.cf.delete(DeletionTime.serializer.deserialize(file));
            }
            catch (Exception e) {
                throw new IOException(serializer + " failed to deserialize " + sstable.getColumnFamilyName() + " with " + sstable.metadata + " from " + file, e);
            }
        } else {
            this.cf = ArrayBackedSortedColumns.factory.create(sstable.metadata);
            this.cf.delete(indexEntry.deletionTime());
        }
        ArrayList<OnDiskAtom> result = new ArrayList<OnDiskAtom>();
        if (indexList.isEmpty()) {
            int columnCount = sstable.descriptor.version.hasRowSizeAndColumnCount ? file.readInt() : Integer.MAX_VALUE;
            this.readSimpleColumns(file, this.columns, result, columnCount);
        } else {
            this.readIndexedColumns(sstable.metadata, file, this.columns, indexList, indexEntry.position, result);
        }
        this.iter = result.iterator();
    }

    private void readSimpleColumns(FileDataInput file, SortedSet<ByteBuffer> columnNames, List<OnDiskAtom> result, int columnCount) {
        Iterator<OnDiskAtom> atomIterator = this.cf.metadata().getOnDiskIterator(file, columnCount, this.sstable.descriptor.version);
        int n = 0;
        while (atomIterator.hasNext()) {
            OnDiskAtom column = atomIterator.next();
            if (column instanceof Column) {
                if (!columnNames.contains(column.name())) continue;
                result.add(column);
                if (++n < this.columns.size()) continue;
                break;
            }
            result.add(column);
        }
    }

    private void readIndexedColumns(CFMetaData metadata, FileDataInput file, SortedSet<ByteBuffer> columnNames, List<IndexHelper.IndexInfo> indexList, long basePosition, List<OnDiskAtom> result) throws IOException {
        AbstractType<?> comparator = metadata.comparator;
        ArrayList<IndexHelper.IndexInfo> ranges = new ArrayList<IndexHelper.IndexInfo>();
        int lastIndexIdx = -1;
        for (ByteBuffer name : this.columns) {
            int index = IndexedSliceReader.indexFor(this.sstable, name, indexList, comparator, false, lastIndexIdx);
            if (index < 0 || index == indexList.size()) continue;
            IndexHelper.IndexInfo indexInfo = indexList.get(index);
            if (IndexedSliceReader.comparatorForIndex(this.sstable, comparator).compare(IndexedSliceReader.forIndexComparison(this.sstable, name), indexInfo.firstName) < 0 || index == lastIndexIdx) continue;
            ranges.add(indexInfo);
            lastIndexIdx = index;
        }
        if (ranges.isEmpty()) {
            return;
        }
        for (IndexHelper.IndexInfo indexInfo : ranges) {
            long positionToSeek = basePosition + indexInfo.offset;
            if (file == null) {
                file = this.createFileDataInput(positionToSeek);
            }
            Iterator<OnDiskAtom> atomIterator = this.cf.metadata().getOnDiskIterator(file, Integer.MAX_VALUE, this.sstable.descriptor.version);
            file.seek(positionToSeek);
            FileMark mark = file.mark();
            while (file.bytesPastMark(mark) < indexInfo.width) {
                OnDiskAtom column = atomIterator.next();
                if (column instanceof Column && !columnNames.contains(column.name())) continue;
                result.add(column);
            }
        }
    }

    @Override
    public DecoratedKey getKey() {
        return this.key;
    }

    @Override
    public ColumnFamily getColumnFamily() {
        return this.cf;
    }

    protected OnDiskAtom computeNext() {
        if (this.iter == null || !this.iter.hasNext()) {
            return (OnDiskAtom)this.endOfData();
        }
        return this.iter.next();
    }

    @Override
    public void close() throws IOException {
    }
}

