/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.filter;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public class QueryPath {
    public final String columnFamilyName;
    public final ByteBuffer superColumnName;
    public final ByteBuffer columnName;

    public QueryPath(String columnFamilyName, ByteBuffer superColumnName, ByteBuffer columnName) {
        this.columnFamilyName = columnFamilyName;
        this.superColumnName = superColumnName;
        this.columnName = columnName;
    }

    public QueryPath(String columnFamilyName, ByteBuffer superColumnName) {
        this(columnFamilyName, superColumnName, null);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + "columnFamilyName='" + this.columnFamilyName + '\'' + ", superColumnName='" + this.superColumnName + '\'' + ", columnName='" + this.columnName + '\'' + ')';
    }

    public void serialize(DataOutput out) throws IOException {
        assert (!"".equals(this.columnFamilyName));
        assert (this.superColumnName == null || this.superColumnName.remaining() > 0);
        assert (this.columnName == null || this.columnName.remaining() > 0);
        out.writeUTF(this.columnFamilyName == null ? "" : this.columnFamilyName);
        ByteBufferUtil.writeWithShortLength(this.superColumnName == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : this.superColumnName, out);
        ByteBufferUtil.writeWithShortLength(this.columnName == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : this.columnName, out);
    }

    public static QueryPath deserialize(DataInput din) throws IOException {
        String cfName = din.readUTF();
        ByteBuffer scName = ByteBufferUtil.readWithShortLength(din);
        ByteBuffer cName = ByteBufferUtil.readWithShortLength(din);
        return new QueryPath(cfName.isEmpty() ? null : cfName, scName.remaining() == 0 ? null : scName, cName.remaining() == 0 ? null : cName);
    }

    public int serializedSize(TypeSizes typeSizes) {
        int size = 0;
        size = this.columnFamilyName == null ? (size += typeSizes.sizeof((short)0)) : (size += typeSizes.sizeof(this.columnFamilyName));
        if (this.superColumnName == null) {
            size += typeSizes.sizeof((short)0);
        } else {
            int scNameSize = this.superColumnName.remaining();
            size += typeSizes.sizeof((short)scNameSize);
            size += scNameSize;
        }
        if (this.columnName == null) {
            size += typeSizes.sizeof((short)0);
        } else {
            int cNameSize = this.columnName.remaining();
            size += typeSizes.sizeof((short)cNameSize);
            size += cNameSize;
        }
        return size;
    }
}

