/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.gms;

import com.netflix.astyanax.shaded.org.apache.cassandra.gms.HeartBeatStateSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.gms.VersionGenerator;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.IVersionedSerializer;

class HeartBeatState {
    public static final IVersionedSerializer<HeartBeatState> serializer = new HeartBeatStateSerializer();
    private int generation;
    private int version;

    HeartBeatState(int gen) {
        this(gen, 0);
    }

    HeartBeatState(int gen, int ver) {
        this.generation = gen;
        this.version = ver;
    }

    int getGeneration() {
        return this.generation;
    }

    void updateHeartBeat() {
        this.version = VersionGenerator.getNextVersion();
    }

    int getHeartBeatVersion() {
        return this.version;
    }

    void forceNewerGenerationUnsafe() {
        ++this.generation;
    }

    void forceHighestPossibleVersionUnsafe() {
        this.version = Integer.MAX_VALUE;
    }

    public String toString() {
        return String.format("HeartBeat: generation = %d, version = %d", this.generation, this.version);
    }
}

