/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.serializers;

import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.CollectionSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.MarshalException;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.TypeSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class SetSerializer<T>
extends CollectionSerializer<Set<T>> {
    private static final Map<TypeSerializer<?>, SetSerializer> instances = new HashMap();
    public final TypeSerializer<T> elements;

    public static synchronized <T> SetSerializer<T> getInstance(TypeSerializer<T> elements) {
        SetSerializer<T> t = instances.get(elements);
        if (t == null) {
            t = new SetSerializer<T>(elements);
            instances.put(elements, t);
        }
        return t;
    }

    private SetSerializer(TypeSerializer<T> elements) {
        this.elements = elements;
    }

    @Override
    public Set<T> deserialize(ByteBuffer bytes) {
        try {
            ByteBuffer input = bytes.duplicate();
            int n = ByteBufferUtil.readShortLength(input);
            LinkedHashSet<T> l = new LinkedHashSet<T>(n);
            for (int i = 0; i < n; ++i) {
                ByteBuffer databb = ByteBufferUtil.readBytesWithShortLength(input);
                this.elements.validate(databb);
                l.add(this.elements.deserialize(databb));
            }
            if (input.hasRemaining()) {
                throw new MarshalException("Unexpected extraneous bytes after set value");
            }
            return l;
        }
        catch (BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a list");
        }
    }

    @Override
    public ByteBuffer serialize(Set<T> value) {
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>(value.size());
        int size = 0;
        for (T elt : value) {
            ByteBuffer bb = this.elements.serialize(elt);
            bbs.add(bb);
            size += 2 + bb.remaining();
        }
        return SetSerializer.pack(bbs, value.size(), size);
    }

    @Override
    public String toString(Set<T> value) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (T element : value) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("; ");
            }
            sb.append(this.elements.toString(element));
        }
        return sb.toString();
    }

    @Override
    public Class<Set<T>> getType() {
        return Set.class;
    }
}

