/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.streaming.messages;

import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.StreamSession;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.messages.StreamMessage;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.UUIDSerializer;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.UUID;

public class ReceivedMessage
extends StreamMessage {
    public static StreamMessage.Serializer<ReceivedMessage> serializer = new StreamMessage.Serializer<ReceivedMessage>(){

        @Override
        public ReceivedMessage deserialize(ReadableByteChannel in, int version, StreamSession session) throws IOException {
            DataInputStream input = new DataInputStream(Channels.newInputStream(in));
            return new ReceivedMessage(UUIDSerializer.serializer.deserialize(input, 7), input.readInt());
        }

        @Override
        public void serialize(ReceivedMessage message, WritableByteChannel out, int version, StreamSession session) throws IOException {
            DataOutputStream output = new DataOutputStream(Channels.newOutputStream(out));
            UUIDSerializer.serializer.serialize(message.cfId, (DataOutput)output, 7);
            output.writeInt(message.sequenceNumber);
        }
    };
    public final UUID cfId;
    public final int sequenceNumber;

    public ReceivedMessage(UUID cfId, int sequenceNumber) {
        super(StreamMessage.Type.RECEIVED);
        this.cfId = cfId;
        this.sequenceNumber = sequenceNumber;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Received (");
        sb.append(this.cfId).append(", #").append(this.sequenceNumber).append(')');
        return sb.toString();
    }
}

