/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.transport;

import com.netflix.astyanax.shaded.org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import com.netflix.astyanax.shaded.org.apache.cassandra.concurrent.NamedThreadFactory;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.DatabaseDescriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.metrics.ThreadPoolMetrics;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.handler.execution.MemoryAwareThreadPoolExecutor;
import org.jboss.netty.util.ObjectSizeEstimator;

public class RequestThreadPoolExecutor
extends MemoryAwareThreadPoolExecutor {
    private static final int CORE_THREAD_TIMEOUT_SEC = 30;
    private static final int MAX_QUEUED_REQUESTS = 128;
    private static final String THREAD_FACTORY_ID = "Native-Transport-Requests";
    private final ThreadPoolMetrics metrics = new ThreadPoolMetrics((ThreadPoolExecutor)((Object)this), "transport", "Native-Transport-Requests");

    public RequestThreadPoolExecutor() {
        super(DatabaseDescriptor.getNativeTransportMaxThreads().intValue(), 0L, 128L, 30L, TimeUnit.SECONDS, RequestThreadPoolExecutor.sizeEstimator(), (ThreadFactory)new NamedThreadFactory(THREAD_FACTORY_ID));
    }

    private static ObjectSizeEstimator sizeEstimator() {
        return new ObjectSizeEstimator(){

            public int estimateSize(Object o) {
                return 1;
            }
        };
    }

    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        DebuggableThreadPoolExecutor.logExceptionsAfterExecute(r, t);
    }

    public void shutdown() {
        if (!this.isShutdown()) {
            this.metrics.release();
        }
        super.shutdown();
    }

    public List<Runnable> shutdownNow() {
        if (!this.isShutdown()) {
            this.metrics.release();
        }
        return super.shutdownNow();
    }
}

