/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages;

import com.netflix.astyanax.shaded.org.apache.cassandra.service.QueryState;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.CBUtil;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.Connection;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.Event;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.Message;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.Server;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.ServerConnection;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ReadyMessage;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;

public class RegisterMessage
extends Message.Request {
    public static final Message.Codec<RegisterMessage> codec = new Message.Codec<RegisterMessage>(){

        @Override
        public RegisterMessage decode(ChannelBuffer body, int version) {
            int length = body.readUnsignedShort();
            ArrayList<Event.Type> eventTypes = new ArrayList<Event.Type>(length);
            for (int i = 0; i < length; ++i) {
                eventTypes.add(CBUtil.readEnumValue(Event.Type.class, body));
            }
            return new RegisterMessage(eventTypes);
        }

        @Override
        public void encode(RegisterMessage msg, ChannelBuffer dest, int version) {
            dest.writeShort(msg.eventTypes.size());
            for (Event.Type type : msg.eventTypes) {
                CBUtil.writeEnumValue(type, dest);
            }
        }

        @Override
        public int encodedSize(RegisterMessage msg, int version) {
            int size = 2;
            for (Event.Type type : msg.eventTypes) {
                size += CBUtil.sizeOfEnumValue(type);
            }
            return size;
        }
    };
    public final List<Event.Type> eventTypes;

    public RegisterMessage(List<Event.Type> eventTypes) {
        super(Message.Type.REGISTER);
        this.eventTypes = eventTypes;
    }

    @Override
    public Message.Response execute(QueryState state) {
        assert (this.connection instanceof ServerConnection);
        Connection.Tracker tracker = ((ServerConnection)this.connection).getTracker();
        assert (tracker instanceof Server.ConnectionTracker);
        for (Event.Type type : this.eventTypes) {
            ((Server.ConnectionTracker)tracker).register(type, this.connection().channel());
        }
        return new ReadyMessage();
    }

    public String toString() {
        return "REGISTER " + this.eventTypes;
    }
}

