/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.atlas.AtlasException;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.groovy.GroovyExpression;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasGraphIndexClient;
import org.apache.atlas.repository.graphdb.AtlasGraphManagement;
import org.apache.atlas.repository.graphdb.AtlasGraphQuery;
import org.apache.atlas.repository.graphdb.AtlasGraphTraversal;
import org.apache.atlas.repository.graphdb.AtlasIndexQuery;
import org.apache.atlas.repository.graphdb.AtlasIndexQueryParameter;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.graphdb.GraphIndexQueryParameters;
import org.apache.atlas.repository.graphdb.GremlinVersion;
import org.apache.atlas.type.AtlasType;

public interface AtlasGraph<V, E> {
    public AtlasEdge<V, E> addEdge(AtlasVertex<V, E> var1, AtlasVertex<V, E> var2, String var3);

    public AtlasEdge<V, E> getEdgeBetweenVertices(AtlasVertex var1, AtlasVertex var2, String var3);

    public AtlasVertex<V, E> addVertex();

    public void removeEdge(AtlasEdge<V, E> var1);

    public void removeVertex(AtlasVertex<V, E> var1);

    public AtlasEdge<V, E> getEdge(String var1);

    public Iterable<AtlasEdge<V, E>> getEdges();

    public Iterable<AtlasVertex<V, E>> getVertices();

    public AtlasVertex<V, E> getVertex(String var1);

    public Set<String> getEdgeIndexKeys();

    public Set<String> getVertexIndexKeys();

    public Iterable<AtlasVertex<V, E>> getVertices(String var1, Object var2);

    public AtlasGraphQuery<V, E> query();

    public AtlasGraphTraversal<AtlasVertex, AtlasEdge> V(Object ... var1);

    public AtlasGraphTraversal<AtlasVertex, AtlasEdge> E(Object ... var1);

    public AtlasIndexQuery<V, E> indexQuery(String var1, String var2);

    public AtlasIndexQuery<V, E> indexQuery(String var1, String var2, int var3);

    public AtlasIndexQuery<V, E> indexQuery(GraphIndexQueryParameters var1);

    public AtlasGraphManagement getManagementSystem();

    public void commit();

    public void rollback();

    public void shutdown();

    public void clear();

    public Set getOpenTransactions();

    public void exportToGson(OutputStream var1) throws IOException;

    public GroovyExpression generatePersisentToLogicalConversionExpression(GroovyExpression var1, AtlasType var2);

    public boolean isPropertyValueConversionNeeded(AtlasType var1);

    public GremlinVersion getSupportedGremlinVersion();

    public boolean requiresInitialIndexedPredicate();

    public GroovyExpression getInitialIndexedPredicate(GroovyExpression var1);

    public GroovyExpression addOutputTransformationPredicate(GroovyExpression var1, boolean var2, boolean var3);

    public ScriptEngine getGremlinScriptEngine() throws AtlasBaseException;

    public void releaseGremlinScriptEngine(ScriptEngine var1);

    public Object executeGremlinScript(String var1, boolean var2) throws AtlasBaseException;

    public Object executeGremlinScript(ScriptEngine var1, Map<? extends String, ? extends Object> var2, String var3, boolean var4) throws ScriptException;

    public boolean isMultiProperty(String var1);

    public AtlasIndexQueryParameter indexQueryParameter(String var1, String var2);

    public AtlasGraphIndexClient getGraphIndexClient() throws AtlasException;
}

