/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.janus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasGraphTraversal;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusEdge;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusGraph;
import org.apache.atlas.repository.graphdb.janus.AtlasJanusVertex;
import org.apache.atlas.repository.graphdb.janus.GraphDbObjectFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.attribute.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasJanusGraphTraversal
extends AtlasGraphTraversal<AtlasJanusVertex, AtlasJanusEdge> {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasJanusGraphTraversal.class);
    private List resultList;
    private Set resultSet;

    public AtlasJanusGraphTraversal() {
    }

    public AtlasJanusGraphTraversal(AtlasGraph<AtlasJanusVertex, AtlasJanusEdge> atlasGraph, GraphTraversalSource traversalSource) {
        super(atlasGraph, traversalSource);
    }

    public AtlasJanusGraphTraversal(AtlasGraph atlasGraph, Graph graph) {
        super(atlasGraph, graph);
    }

    public AtlasGraphTraversal startAnonymousTraversal() {
        return new AtlasJanusGraphTraversal();
    }

    public List<AtlasJanusVertex> getAtlasVertexList() {
        List<AtlasJanusVertex> ret;
        List list = this.getResultList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            if (list.size() == 1 && list.get(0) instanceof Map) {
                ret = Collections.emptyList();
            } else {
                ret = new ArrayList<AtlasJanusVertex>(list.size());
                for (Object o : list) {
                    if (!(o instanceof Vertex)) continue;
                    ret.add(GraphDbObjectFactory.createVertex((AtlasJanusGraph)this.atlasGraph, (Vertex)o));
                }
            }
        } else {
            ret = Collections.emptyList();
        }
        return ret;
    }

    public Set<AtlasJanusVertex> getAtlasVertexSet() {
        Set<AtlasJanusVertex> ret;
        Set set = this.getResultSet();
        if (CollectionUtils.isNotEmpty((Collection)set)) {
            ret = new HashSet<AtlasJanusVertex>(set.size());
            for (Object o : set) {
                if (!(o instanceof Vertex)) continue;
                ret.add(GraphDbObjectFactory.createVertex((AtlasJanusGraph)this.atlasGraph, (Vertex)o));
            }
        } else {
            ret = Collections.emptySet();
        }
        return ret;
    }

    public Map<String, Collection<AtlasJanusVertex>> getAtlasVertexMap() {
        Map<String, Collection<AtlasJanusVertex>> ret;
        List list = this.getResultList();
        if (CollectionUtils.isNotEmpty((Collection)list) && list.get(0) instanceof Map) {
            Map map = (Map)list.get(0);
            ret = new HashMap<String, Collection<AtlasJanusVertex>>(map.size());
            for (Object key : map.keySet()) {
                Object value;
                if (!(key instanceof String) || !((value = map.get(key)) instanceof List)) continue;
                ArrayList<AtlasJanusVertex> values = new ArrayList<AtlasJanusVertex>();
                for (Object o : (List)value) {
                    if (o instanceof Vertex) {
                        values.add(GraphDbObjectFactory.createVertex((AtlasJanusGraph)this.atlasGraph, (Vertex)o));
                        continue;
                    }
                    LOG.warn("{} is not a vertex.", (Object)o.getClass().getSimpleName());
                }
                ret.put((String)key, values);
            }
        } else {
            ret = Collections.emptyMap();
        }
        return ret;
    }

    public Set<AtlasJanusEdge> getAtlasEdgeSet() {
        Set<AtlasJanusEdge> ret;
        Set set = this.getResultSet();
        if (CollectionUtils.isNotEmpty((Collection)set)) {
            ret = new HashSet<AtlasJanusEdge>(set.size());
            for (Object o : set) {
                if (!(o instanceof Edge)) continue;
                ret.add(GraphDbObjectFactory.createEdge((AtlasJanusGraph)this.atlasGraph, (Edge)o));
            }
        } else {
            ret = Collections.emptySet();
        }
        return ret;
    }

    public Map<String, AtlasJanusEdge> getAtlasEdgeMap() {
        return null;
    }

    public AtlasGraphTraversal.TextPredicate textPredicate() {
        return new JanusGraphPredicate();
    }

    public AtlasGraphTraversal textRegEx(String key, String value) {
        return (AtlasGraphTraversal)this.has(key, Text.textRegex((Object)value));
    }

    public AtlasGraphTraversal textContainsRegEx(String key, String value) {
        return (AtlasGraphTraversal)this.has(key, Text.textContainsRegex((Object)value));
    }

    private List getResultList() {
        if (this.resultList == null) {
            this.resultList = this.toList();
        }
        return this.resultList;
    }

    private Set getResultSet() {
        if (this.resultSet == null) {
            this.resultSet = this.toSet();
        }
        return this.resultSet;
    }

    public static class JanusGraphPredicate
    implements AtlasGraphTraversal.TextPredicate {
        public BiPredicate<Object, Object> contains() {
            return Text.CONTAINS;
        }

        public BiPredicate<Object, Object> containsPrefix() {
            return Text.CONTAINS_PREFIX;
        }

        public BiPredicate<Object, Object> containsRegex() {
            return Text.CONTAINS_REGEX;
        }

        public BiPredicate<Object, Object> prefix() {
            return Text.PREFIX;
        }

        public BiPredicate<Object, Object> regex() {
            return Text.REGEX;
        }
    }
}

