/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.notification;

import java.util.List;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.repository.store.graph.EntityCorrelationStore;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityCorrelationManager {
    private static final Logger LOG = LoggerFactory.getLogger(EntityCorrelationManager.class);
    private final EntityCorrelationStore entityCorrelationStore;

    public EntityCorrelationManager(EntityCorrelationStore entityCorrelationStore) {
        this.entityCorrelationStore = entityCorrelationStore;
    }

    public void add(boolean spooled, long spooledTimestamp, List<AtlasEntityHeader> entityHeaders) {
        if (this.entityCorrelationStore == null || !spooled || CollectionUtils.isEmpty(entityHeaders)) {
            return;
        }
        for (AtlasEntityHeader entityHeader : entityHeaders) {
            String guid = entityHeader.getGuid();
            if (!StringUtils.isNotEmpty((String)guid)) continue;
            this.entityCorrelationStore.add(guid, spooledTimestamp);
        }
    }

    public String getGuidForDeletedEntityToBeCorrelated(String qualifiedName, long spooledMessageTimestamp) {
        if (this.entityCorrelationStore == null || spooledMessageTimestamp <= 0L) {
            return null;
        }
        String guid = this.entityCorrelationStore.findCorrelatedGuid(qualifiedName, spooledMessageTimestamp);
        LOG.info("{}: spooledTimestamp: {} -> {}", new Object[]{qualifiedName, spooledMessageTimestamp, guid});
        return guid;
    }
}

