/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.notification.preprocessor;

import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.notification.preprocessor.EntityPreprocessor;
import org.apache.atlas.notification.preprocessor.PreprocessorContext;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveTableDDLPreprocessor
extends EntityPreprocessor {
    private static final Logger LOG = LoggerFactory.getLogger(HiveTableDDLPreprocessor.class);

    protected HiveTableDDLPreprocessor() {
        super("hive_table_ddl");
    }

    @Override
    public void preprocess(AtlasEntity entity, PreprocessorContext context) {
        if (!context.isSpooledMessage()) {
            return;
        }
        Object tableObject = entity.getRelationshipAttribute("table");
        if (tableObject == null) {
            return;
        }
        String qualifiedName = this.getQualifiedName(tableObject);
        String guid = context.getGuidForDeletedEntity(qualifiedName);
        if (StringUtils.isEmpty((String)guid)) {
            return;
        }
        this.setObjectIdWithGuid(tableObject, guid);
        LOG.info("{}: Preprocessor: Updated: {} -> {}", new Object[]{this.getTypeName(), qualifiedName, guid});
    }
}

