/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.filters;

import com.google.common.annotations.VisibleForTesting;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.SignedJWT;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.web.filters.AtlasResponseRequestWrapper;
import org.apache.atlas.web.filters.HeadersUtil;
import org.apache.atlas.web.filters.SSOAuthentication;
import org.apache.atlas.web.filters.SSOAuthenticationProperties;
import org.apache.atlas.web.security.AtlasAuthenticationProvider;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.stereotype.Component;

@Component(value="ssoAuthenticationFilter")
public class AtlasKnoxSSOAuthenticationFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasKnoxSSOAuthenticationFilter.class);
    public static final String BROWSER_USERAGENT = "atlas.sso.knox.browser.useragent";
    public static final String JWT_AUTH_PROVIDER_URL = "atlas.sso.knox.providerurl";
    public static final String JWT_PUBLIC_KEY = "atlas.sso.knox.publicKey";
    public static final String JWT_COOKIE_NAME = "atlas.sso.knox.cookiename";
    public static final String JWT_ORIGINAL_URL_QUERY_PARAM = "atlas.sso.knox.query.param.originalurl";
    public static final String JWT_COOKIE_NAME_DEFAULT = "hadoop-jwt";
    public static final String JWT_ORIGINAL_URL_QUERY_PARAM_DEFAULT = "originalUrl";
    public static final String DEFAULT_BROWSER_USERAGENT = "Mozilla,Opera,Chrome";
    public static final String PROXY_ATLAS_URL_PATH = "/atlas";
    private final AtlasAuthenticationProvider authenticationProvider;
    private SSOAuthenticationProperties jwtProperties;
    private String originalUrlQueryParam = "originalUrl";
    private String authenticationProviderUrl = null;
    private RSAPublicKey publicKey = null;
    private String cookieName = "hadoop-jwt";
    private Configuration configuration = null;
    private boolean ssoEnabled = false;
    private JWSVerifier verifier = null;
    @VisibleForTesting
    private final int MAX_LOGIN_URL_LENGTH = 2043;

    @Inject
    public AtlasKnoxSSOAuthenticationFilter(AtlasAuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
        try {
            this.configuration = ApplicationProperties.get();
        }
        catch (Exception e) {
            LOG.error("Error while getting application properties", (Throwable)e);
        }
        if (this.configuration != null) {
            this.ssoEnabled = this.configuration.getBoolean("atlas.sso.knox.enabled", false);
            this.jwtProperties = this.loadJwtProperties();
        }
        this.setJwtProperties();
    }

    public AtlasKnoxSSOAuthenticationFilter(AtlasAuthenticationProvider authenticationProvider, SSOAuthenticationProperties jwtProperties) {
        this.authenticationProvider = authenticationProvider;
        this.jwtProperties = jwtProperties;
        this.setJwtProperties();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        block11: {
            HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
            AtlasResponseRequestWrapper responseWrapper = new AtlasResponseRequestWrapper(httpResponse);
            HeadersUtil.setHeaderMapAttributes(responseWrapper, "X-Content-Type-Options");
            HeadersUtil.setHeaderMapAttributes(responseWrapper, "X-XSS-Protection");
            HeadersUtil.setHeaderMapAttributes(responseWrapper, "Strict-Transport-Security");
            if (!this.ssoEnabled) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Knox doFilter {}", (Object)httpRequest.getRequestURI());
            }
            if (httpRequest.getSession() != null && httpRequest.getSession().getAttribute("locallogin") != null) {
                servletRequest.setAttribute("ssoEnabled", (Object)false);
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            if (this.jwtProperties == null || this.isAuthenticated()) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Knox ssoEnabled  {} {}", (Object)this.ssoEnabled, (Object)httpRequest.getRequestURI());
            }
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            String serializedJWT = this.getJWTFromCookie(httpRequest);
            if (serializedJWT != null) {
                SignedJWT jwtToken = null;
                try {
                    jwtToken = SignedJWT.parse((String)serializedJWT);
                    boolean valid = this.validateToken(jwtToken);
                    if (valid) {
                        String userName = jwtToken.getJWTClaimsSet().getSubject();
                        LOG.info("SSO login user : {} ", (Object)userName);
                        if (userName != null && !userName.trim().isEmpty()) {
                            List<GrantedAuthority> grantedAuths = AtlasAuthenticationProvider.getAuthoritiesFromUGI(userName);
                            User principal = new User(userName, "", grantedAuths);
                            UsernamePasswordAuthenticationToken finalAuthentication = new UsernamePasswordAuthenticationToken((Object)principal, (Object)"", grantedAuths);
                            WebAuthenticationDetails webDetails = new WebAuthenticationDetails(httpRequest);
                            ((AbstractAuthenticationToken)finalAuthentication).setDetails((Object)webDetails);
                            this.authenticationProvider.setSsoEnabled(this.ssoEnabled);
                            Authentication authentication = this.authenticationProvider.authenticate((Authentication)finalAuthentication);
                            SecurityContextHolder.getContext().setAuthentication(authentication);
                        }
                        filterChain.doFilter(servletRequest, (ServletResponse)httpServletResponse);
                        break block11;
                    }
                    this.redirectToKnox(httpRequest, httpServletResponse, filterChain);
                }
                catch (ParseException e) {
                    LOG.warn("Unable to parse the JWT token", (Throwable)e);
                    this.redirectToKnox(httpRequest, httpServletResponse, filterChain);
                }
            } else {
                this.redirectToKnox(httpRequest, httpServletResponse, filterChain);
            }
        }
    }

    private void redirectToKnox(HttpServletRequest httpRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!this.isWebUserAgent(httpRequest.getHeader("User-Agent"))) {
            filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpServletResponse);
            return;
        }
        String ajaxRequestHeader = httpRequest.getHeader("X-Requested-With");
        if ("XMLHttpRequest".equals(ajaxRequestHeader)) {
            String ssourl = this.constructLoginURL(httpRequest, true);
            JSONObject json = new JSONObject();
            json.put((Object)"knoxssoredirectURL", (Object)URLEncoder.encode(ssourl, "UTF-8"));
            httpServletResponse.setContentType("application/json");
            httpServletResponse.setStatus(401);
            httpServletResponse.sendError(401, json.toString());
        } else {
            String ssourl = this.constructLoginURL(httpRequest, false);
            httpServletResponse.sendRedirect(ssourl);
        }
    }

    private boolean isWebUserAgent(String userAgent) {
        String[] userAgentList;
        boolean isWeb = false;
        if (this.jwtProperties != null && (userAgentList = this.jwtProperties.getUserAgentList()) != null && userAgentList.length > 0) {
            for (String ua : userAgentList) {
                if (!StringUtils.startsWithIgnoreCase((String)userAgent, (String)ua)) continue;
                isWeb = true;
                break;
            }
        }
        return isWeb;
    }

    private void setJwtProperties() {
        if (this.jwtProperties != null) {
            this.authenticationProviderUrl = this.jwtProperties.getAuthenticationProviderUrl();
            this.publicKey = this.jwtProperties.getPublicKey();
            this.cookieName = this.jwtProperties.getCookieName();
            this.originalUrlQueryParam = this.jwtProperties.getOriginalUrlQueryParam();
            if (this.publicKey != null) {
                this.verifier = new RSASSAVerifier(this.publicKey);
            }
        }
    }

    private boolean isAuthenticated() {
        Authentication existingAuth = SecurityContextHolder.getContext().getAuthentication();
        return existingAuth != null && existingAuth.isAuthenticated() && !(existingAuth instanceof SSOAuthentication);
    }

    protected String getJWTFromCookie(HttpServletRequest req) {
        String serializedJWT = null;
        Cookie[] cookies = req.getCookies();
        if (this.cookieName != null && cookies != null) {
            for (Cookie cookie : cookies) {
                if (!this.cookieName.equals(cookie.getName())) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} cookie has been found and is being processed", (Object)this.cookieName);
                }
                serializedJWT = cookie.getValue();
                break;
            }
        }
        return serializedJWT;
    }

    protected String constructLoginURL(HttpServletRequest request, boolean isXMLRequest) {
        String delimiter = "?";
        if (this.authenticationProviderUrl.contains("?")) {
            delimiter = "&";
        }
        String xForwardedURL = this.constructForwardableURL(this.parseXForwardHeader(request), request.getRequestURI());
        StringBuilder knoxLoginURL = new StringBuilder();
        knoxLoginURL.append(this.authenticationProviderUrl).append(delimiter).append(this.originalUrlQueryParam).append("=");
        if (isXMLRequest) {
            String atlasApplicationURL = "";
            String referalURL = request.getHeader("referer");
            atlasApplicationURL = referalURL == null ? request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() : referalURL;
            if (StringUtils.trimToNull((String)xForwardedURL) != null) {
                this.safeAppend(knoxLoginURL, xForwardedURL, atlasApplicationURL);
            } else {
                this.safeAppend(knoxLoginURL, atlasApplicationURL);
            }
        } else if (StringUtils.trimToNull((String)xForwardedURL) != null) {
            this.safeAppend(knoxLoginURL, xForwardedURL, this.getOriginalQueryString(request));
        } else {
            this.safeAppend(knoxLoginURL, request.getRequestURL().toString(), this.getOriginalQueryString(request));
        }
        return knoxLoginURL.toString();
    }

    private String getOriginalQueryString(HttpServletRequest request) {
        String originalQueryString = request.getQueryString();
        return originalQueryString == null ? "" : "?" + originalQueryString;
    }

    private Map<String, String> parseXForwardHeader(HttpServletRequest httpRequest) {
        String xForwardedProto = "";
        String xForwardedHost = "";
        String xForwardedContext = "";
        HashMap<String, String> xFwdHeaderMap = null;
        Enumeration names = httpRequest.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = httpRequest.getHeaders(name);
            String value = "";
            if (values != null) {
                while (values.hasMoreElements()) {
                    value = (String)values.nextElement();
                }
            }
            if (StringUtils.trimToNull((String)name) == null || StringUtils.trimToNull((String)value) == null) continue;
            if (name.equalsIgnoreCase("x-forwarded-proto")) {
                xForwardedProto = value;
                continue;
            }
            if (name.equalsIgnoreCase("x-forwarded-host")) {
                xForwardedHost = value;
                continue;
            }
            if (!name.equalsIgnoreCase("x-forwarded-context")) continue;
            xForwardedContext = value;
        }
        if (StringUtils.isNotEmpty((String)xForwardedProto) && StringUtils.isNotEmpty((String)xForwardedHost) && StringUtils.isNotEmpty((String)xForwardedContext)) {
            xFwdHeaderMap = new HashMap<String, String>();
            xFwdHeaderMap.put("x-forwarded-proto", xForwardedProto);
            xFwdHeaderMap.put("x-forwarded-host", xForwardedHost);
            xFwdHeaderMap.put("x-forwarded-context", xForwardedContext);
        }
        return xFwdHeaderMap;
    }

    private String constructForwardableURL(Map<String, String> xFwdHeaderMap, String requestURI) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(" constructForwardableURL ==>>" + xFwdHeaderMap + " requestURI " + requestURI);
        }
        String xForwardedURL = null;
        if (xFwdHeaderMap != null) {
            String xForwardedProto = xFwdHeaderMap.get("x-forwarded-proto");
            String xForwardedHost = xFwdHeaderMap.get("x-forwarded-host");
            String xForwardedContext = xFwdHeaderMap.get("x-forwarded-context");
            if (StringUtils.isNotBlank((String)xForwardedProto) && StringUtils.isNotBlank((String)xForwardedHost) && StringUtils.isNotBlank((String)xForwardedContext)) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(" Atlas url with proxy path ==>" + xForwardedProto + "://" + xForwardedHost + xForwardedContext + PROXY_ATLAS_URL_PATH + requestURI);
                    }
                    URIBuilder builder = new URIBuilder();
                    builder.setScheme(xForwardedProto).setHost(xForwardedHost).setPath(xForwardedContext + PROXY_ATLAS_URL_PATH + requestURI);
                    xForwardedURL = builder.build().toString();
                }
                catch (URISyntaxException ue) {
                    LOG.error(" URISyntaxException while build xforward url ", (Throwable)ue);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" xForwardedURL ==>> " + xForwardedURL);
        }
        return xForwardedURL;
    }

    @VisibleForTesting
    void safeAppend(StringBuilder sb, String ... strings) {
        for (String s : strings) {
            if (sb.length() + s.length() >= 2043) continue;
            sb.append(s);
        }
    }

    protected boolean validateToken(SignedJWT jwtToken) {
        boolean isValid = this.validateSignature(jwtToken);
        if (isValid) {
            isValid = this.validateExpiration(jwtToken);
            if (!isValid) {
                LOG.warn("Expiration time validation of JWT token failed.");
            }
        } else {
            LOG.warn("Signature of JWT token could not be verified. Please check the public key");
        }
        return isValid;
    }

    protected boolean validateSignature(SignedJWT jwtToken) {
        boolean valid = false;
        if (JWSObject.State.SIGNED == jwtToken.getState()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("SSO token is in a SIGNED state");
            }
            if (jwtToken.getSignature() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("SSO token signature is not null");
                }
                try {
                    if (this.verifier != null && jwtToken.verify(this.verifier)) {
                        valid = true;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("SSO token has been successfully verified");
                        }
                    } else {
                        LOG.warn("SSO signature verification failed.Please check the public key");
                    }
                }
                catch (JOSEException je) {
                    LOG.warn("Error while validating signature", (Throwable)je);
                }
                catch (Exception e) {
                    LOG.warn("Error while validating signature", (Throwable)e);
                }
            }
        }
        return valid;
    }

    protected boolean validateExpiration(SignedJWT jwtToken) {
        boolean valid = false;
        try {
            Date expires = jwtToken.getJWTClaimsSet().getExpirationTime();
            if (expires == null || new Date().before(expires)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("SSO token expiration date has been successfully validated");
                }
                valid = true;
            } else {
                LOG.warn("SSO expiration date validation failed.");
            }
        }
        catch (ParseException pe) {
            LOG.warn("SSO expiration date validation failed.", (Throwable)pe);
        }
        return valid;
    }

    public void destroy() {
    }

    public SSOAuthenticationProperties loadJwtProperties() {
        String providerUrl = this.configuration.getString(JWT_AUTH_PROVIDER_URL);
        if (providerUrl != null && this.configuration.getBoolean("atlas.sso.knox.enabled", false)) {
            SSOAuthenticationProperties jwtProperties = new SSOAuthenticationProperties();
            String publicKeyPathStr = this.configuration.getString(JWT_PUBLIC_KEY);
            if (publicKeyPathStr == null) {
                LOG.error("Public key pem not specified for SSO auth provider {}. SSO auth will be disabled");
                return null;
            }
            jwtProperties.setAuthenticationProviderUrl(providerUrl);
            jwtProperties.setCookieName(this.configuration.getString(JWT_COOKIE_NAME, JWT_COOKIE_NAME_DEFAULT));
            jwtProperties.setOriginalUrlQueryParam(this.configuration.getString(JWT_ORIGINAL_URL_QUERY_PARAM, JWT_ORIGINAL_URL_QUERY_PARAM_DEFAULT));
            String[] userAgent = this.configuration.getStringArray(BROWSER_USERAGENT);
            if (userAgent != null && userAgent.length > 0) {
                jwtProperties.setUserAgentList(userAgent);
            } else {
                jwtProperties.setUserAgentList(DEFAULT_BROWSER_USERAGENT.split(","));
            }
            try {
                RSAPublicKey publicKey = AtlasKnoxSSOAuthenticationFilter.parseRSAPublicKey(publicKeyPathStr);
                jwtProperties.setPublicKey(publicKey);
            }
            catch (IOException e) {
                LOG.error("Unable to read public certificate file. JWT auth will be disabled.", (Throwable)e);
            }
            catch (CertificateException e) {
                LOG.error("Unable to parse public certificate file. JWT auth will be disabled.", (Throwable)e);
            }
            catch (ServletException e) {
                LOG.error("ServletException while processing the properties", (Throwable)e);
            }
            return jwtProperties;
        }
        return null;
    }

    public static RSAPublicKey parseRSAPublicKey(String pem) throws CertificateException, UnsupportedEncodingException, ServletException {
        String PEM_HEADER = "-----BEGIN CERTIFICATE-----\n";
        String PEM_FOOTER = "\n-----END CERTIFICATE-----";
        String fullPem = PEM_HEADER + pem + PEM_FOOTER;
        PublicKey key = null;
        try {
            CertificateFactory fact = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream is = new ByteArrayInputStream(fullPem.getBytes("UTF8"));
            X509Certificate cer = (X509Certificate)fact.generateCertificate(is);
            key = cer.getPublicKey();
        }
        catch (CertificateException ce) {
            String message = null;
            message = pem.startsWith(PEM_HEADER) ? "CertificateException - be sure not to include PEM header and footer in the PEM configuration element." : "CertificateException - PEM may be corrupt";
            throw new ServletException(message, (Throwable)ce);
        }
        catch (UnsupportedEncodingException uee) {
            throw new ServletException((Throwable)uee);
        }
        return (RSAPublicKey)key;
    }
}

