/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.resources;

import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.discovery.AtlasLineageService;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.lineage.AtlasLineageInfo;
import org.apache.atlas.repository.store.graph.AtlasEntityStore;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.atlas.v1.model.lineage.DataSetLineageResponse;
import org.apache.atlas.v1.model.lineage.SchemaResponse;
import org.apache.atlas.web.util.LineageUtils;
import org.apache.atlas.web.util.Servlets;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Path(value="lineage/hive")
@Singleton
@Service
@Deprecated
public class DataSetLineageResource {
    private static final Logger LOG = LoggerFactory.getLogger(DataSetLineageResource.class);
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"rest.DataSetLineageResource");
    private final AtlasLineageService atlasLineageService;
    private final AtlasTypeRegistry typeRegistry;
    private final AtlasEntityStore atlasEntityStore;

    @Inject
    public DataSetLineageResource(AtlasLineageService atlasLineageService, AtlasTypeRegistry typeRegistry, AtlasEntityStore atlasEntityStore) {
        this.atlasLineageService = atlasLineageService;
        this.typeRegistry = typeRegistry;
        this.atlasEntityStore = atlasEntityStore;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="table/{tableName}/inputs/graph")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public DataSetLineageResponse inputsGraph(@Context HttpServletRequest request, @PathParam(value="tableName") String tableName) {
        DataSetLineageResponse dataSetLineageResponse;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> DataSetLineageResource.inputsGraph({})", (Object)tableName);
        }
        DataSetLineageResponse ret = new DataSetLineageResponse();
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("DataSetLineageResource.inputsGraph(tableName=" + tableName + ")"));
            }
            String guid = this.getGuid(tableName);
            AtlasLineageInfo lineageInfo = this.atlasLineageService.getAtlasLineageInfo(guid, AtlasLineageInfo.LineageDirection.INPUT, -1);
            ret.setTableName(tableName);
            ret.setRequestId(Servlets.getRequestId());
            ret.setResults(LineageUtils.toLineageStruct(lineageInfo, this.typeRegistry));
            dataSetLineageResponse = ret;
        }
        catch (IllegalArgumentException e) {
            try {
                LOG.error("Unable to get lineage inputs graph for table {}", (Object)tableName, (Object)e);
                throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
                catch (WebApplicationException e2) {
                    LOG.error("Unable to get lineage inputs graph for table {}", (Object)tableName, (Object)e2);
                    throw e2;
                }
                catch (Throwable e3) {
                    LOG.error("Unable to get lineage inputs graph for table {}", (Object)tableName, (Object)e3);
                    throw new WebApplicationException(Servlets.getErrorResponse(e3, Response.Status.INTERNAL_SERVER_ERROR));
                }
            }
            catch (Throwable throwable) {
                AtlasPerfTracer.log(perf);
                throw throwable;
            }
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return dataSetLineageResponse;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="table/{tableName}/outputs/graph")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public DataSetLineageResponse outputsGraph(@Context HttpServletRequest request, @PathParam(value="tableName") String tableName) {
        DataSetLineageResponse dataSetLineageResponse;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> DataSetLineageResource.outputsGraph({})", (Object)tableName);
        }
        DataSetLineageResponse ret = new DataSetLineageResponse();
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("DataSetLineageResource.outputsGraph(tableName=" + tableName + ")"));
            }
            String guid = this.getGuid(tableName);
            AtlasLineageInfo lineageInfo = this.atlasLineageService.getAtlasLineageInfo(guid, AtlasLineageInfo.LineageDirection.OUTPUT, -1);
            ret.setTableName(tableName);
            ret.setRequestId(Servlets.getRequestId());
            ret.setResults(LineageUtils.toLineageStruct(lineageInfo, this.typeRegistry));
            dataSetLineageResponse = ret;
        }
        catch (IllegalArgumentException e) {
            try {
                LOG.error("Unable to get lineage outputs graph for table {}", (Object)tableName, (Object)e);
                throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
                catch (WebApplicationException e2) {
                    LOG.error("Unable to get lineage outputs graph for table {}", (Object)tableName, (Object)e2);
                    throw e2;
                }
                catch (Throwable e3) {
                    LOG.error("Unable to get lineage outputs graph for table {}", (Object)tableName, (Object)e3);
                    throw new WebApplicationException(Servlets.getErrorResponse(e3, Response.Status.INTERNAL_SERVER_ERROR));
                }
            }
            catch (Throwable throwable) {
                AtlasPerfTracer.log(perf);
                throw throwable;
            }
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return dataSetLineageResponse;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="table/{tableName}/schema")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public SchemaResponse schema(@Context HttpServletRequest request, @PathParam(value="tableName") String tableName) {
        SchemaResponse schemaResponse;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> DataSetLineageResource.schema({})", (Object)tableName);
        }
        AtlasPerfTracer perf = null;
        SchemaResponse ret = new SchemaResponse();
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("DataSetLineageResource.schema(tableName=" + tableName + ")"));
            }
            SchemaResponse.SchemaDetails schemaDetails = this.atlasLineageService.getSchemaForHiveTableByName(tableName);
            ret.setRequestId(Servlets.getRequestId());
            ret.setTableName(tableName);
            ret.setResults(schemaDetails);
            schemaResponse = ret;
        }
        catch (IllegalArgumentException e) {
            try {
                LOG.error("Unable to get schema for table {}", (Object)tableName, (Object)e);
                throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
                catch (WebApplicationException e2) {
                    LOG.error("Unable to get schema for table {}", (Object)tableName, (Object)e2);
                    throw e2;
                }
                catch (Throwable e3) {
                    LOG.error("Unable to get schema for table {}", (Object)tableName, (Object)e3);
                    throw new WebApplicationException(Servlets.getErrorResponse(e3, Response.Status.INTERNAL_SERVER_ERROR));
                }
            }
            catch (Throwable throwable) {
                AtlasPerfTracer.log(perf);
                throw throwable;
            }
        }
        AtlasPerfTracer.log((AtlasPerfTracer)perf);
        return schemaResponse;
    }

    private String getGuid(String tableName) throws AtlasBaseException {
        if (StringUtils.isEmpty((String)tableName)) {
            throw new AtlasBaseException(AtlasErrorCode.BAD_REQUEST, new String[0]);
        }
        HashMap<String, String> lookupAttributes = new HashMap<String, String>();
        lookupAttributes.put("qualifiedName", tableName);
        AtlasEntityType entityType = this.typeRegistry.getEntityTypeByName("hive_table");
        AtlasEntity.AtlasEntityWithExtInfo hive_table = this.atlasEntityStore.getByUniqueAttributes(entityType, lookupAttributes);
        if (hive_table != null) {
            return hive_table.getEntity().getGuid();
        }
        throw new AtlasBaseException(AtlasErrorCode.INSTANCE_NOT_FOUND, new String[]{tableName});
    }
}

