/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.rest;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.annotation.Timed;
import org.apache.atlas.discovery.AtlasLineageService;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.lineage.AtlasLineageInfo;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.atlas.web.util.Servlets;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Path(value="v2/lineage")
@Singleton
@Service
@Consumes(value={"application/json; charset=UTF-8", "application/json"})
@Produces(value={"application/json; charset=UTF-8", "application/json"})
public class LineageREST {
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"rest.LineageREST");
    private static final String PREFIX_ATTR = "attr:";
    private final AtlasTypeRegistry typeRegistry;
    private final AtlasLineageService atlasLineageService;
    private static final String DEFAULT_DIRECTION = "BOTH";
    private static final String DEFAULT_DEPTH = "3";
    @Context
    private HttpServletRequest httpServletRequest;

    @Inject
    public LineageREST(AtlasTypeRegistry typeRegistry, AtlasLineageService atlasLineageService) {
        this.typeRegistry = typeRegistry;
        this.atlasLineageService = atlasLineageService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{guid}")
    @Timed
    public AtlasLineageInfo getLineageGraph(@PathParam(value="guid") String guid, @QueryParam(value="direction") @DefaultValue(value="BOTH") AtlasLineageInfo.LineageDirection direction, @QueryParam(value="depth") @DefaultValue(value="3") int depth) throws AtlasBaseException {
        Servlets.validateQueryParamLength("guid", guid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("LineageREST.getLineageGraph(" + guid + "," + direction + "," + depth + ")"));
            }
            AtlasLineageInfo atlasLineageInfo = this.atlasLineageService.getAtlasLineageInfo(guid, direction, depth);
            return atlasLineageInfo;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/uniqueAttribute/type/{typeName}")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    @Timed
    public AtlasLineageInfo getLineageByUniqueAttribute(@PathParam(value="typeName") String typeName, @QueryParam(value="direction") @DefaultValue(value="BOTH") AtlasLineageInfo.LineageDirection direction, @QueryParam(value="depth") @DefaultValue(value="3") int depth, @Context HttpServletRequest servletRequest) throws AtlasBaseException {
        Servlets.validateQueryParamLength("typeName", typeName);
        AtlasPerfTracer perf = null;
        try {
            AtlasEntityType entityType = this.ensureEntityType(typeName);
            Map<String, Object> attributes = this.getAttributes(servletRequest);
            String guid = AtlasGraphUtilsV2.getGuidByUniqueAttributes((AtlasEntityType)entityType, attributes);
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("LineageREST.getLineageByUniqueAttribute(" + typeName + "," + attributes + "," + direction + "," + depth + ")"));
            }
            AtlasLineageInfo atlasLineageInfo = this.atlasLineageService.getAtlasLineageInfo(guid, direction, depth);
            return atlasLineageInfo;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    private Map<String, Object> getAttributes(HttpServletRequest request) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (MapUtils.isNotEmpty((Map)request.getParameterMap())) {
            for (Map.Entry e : request.getParameterMap().entrySet()) {
                String key = (String)e.getKey();
                if (key == null || !key.startsWith(PREFIX_ATTR)) continue;
                String[] values = (String[])e.getValue();
                String value = values != null && values.length > 0 ? values[0] : null;
                attributes.put(key.substring(PREFIX_ATTR.length()), value);
            }
        }
        return attributes;
    }

    private AtlasEntityType ensureEntityType(String typeName) throws AtlasBaseException {
        AtlasEntityType ret = this.typeRegistry.getEntityTypeByName(typeName);
        if (ret == null) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID, new String[]{TypeCategory.ENTITY.name(), typeName});
        }
        return ret;
    }
}

