/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.rest;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.atlas.annotation.Timed;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.repository.store.graph.AtlasRelationshipStore;
import org.apache.atlas.utils.AtlasPerfTracer;
import org.apache.atlas.web.util.Servlets;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Path(value="v2/relationship")
@Singleton
@Service
@Consumes(value={"application/json; charset=UTF-8", "application/json"})
@Produces(value={"application/json; charset=UTF-8", "application/json"})
public class RelationshipREST {
    private static final Logger PERF_LOG = AtlasPerfTracer.getPerfLogger((String)"rest.RelationshipREST");
    private final AtlasRelationshipStore relationshipStore;

    @Inject
    public RelationshipREST(AtlasRelationshipStore relationshipStore) {
        this.relationshipStore = relationshipStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Timed
    public AtlasRelationship create(AtlasRelationship relationship) throws AtlasBaseException {
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("RelationshipREST.create(" + relationship + ")"));
            }
            AtlasRelationship atlasRelationship = this.relationshipStore.create(relationship);
            return atlasRelationship;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Timed
    public AtlasRelationship update(AtlasRelationship relationship) throws AtlasBaseException {
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("RelationshipREST.update(" + relationship + ")"));
            }
            AtlasRelationship atlasRelationship = this.relationshipStore.update(relationship);
            return atlasRelationship;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/guid/{guid}")
    @Timed
    public AtlasRelationship.AtlasRelationshipWithExtInfo getById(@PathParam(value="guid") String guid, @QueryParam(value="extendedInfo") @DefaultValue(value="false") boolean extendedInfo) throws AtlasBaseException {
        Servlets.validateQueryParamLength("guid", guid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("RelationshipREST.getById(" + guid + ")"));
            }
            AtlasRelationship.AtlasRelationshipWithExtInfo ret = extendedInfo ? this.relationshipStore.getExtInfoById(guid) : new AtlasRelationship.AtlasRelationshipWithExtInfo(this.relationshipStore.getById(guid));
            AtlasRelationship.AtlasRelationshipWithExtInfo atlasRelationshipWithExtInfo = ret;
            return atlasRelationshipWithExtInfo;
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }

    @DELETE
    @Path(value="/guid/{guid}")
    @Timed
    public void deleteById(@PathParam(value="guid") String guid) throws AtlasBaseException {
        Servlets.validateQueryParamLength("guid", guid);
        AtlasPerfTracer perf = null;
        try {
            if (AtlasPerfTracer.isPerfTraceEnabled((Logger)PERF_LOG)) {
                perf = AtlasPerfTracer.getPerfTracer((Logger)PERF_LOG, (String)("RelationshipREST.deleteById(" + guid + ")"));
            }
            this.relationshipStore.deleteById(guid);
        }
        finally {
            AtlasPerfTracer.log(perf);
        }
    }
}

