/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.service;

import java.util.HashMap;
import org.apache.atlas.web.model.DebugMetrics;
import org.apache.atlas.web.service.AtlasDebugMetricsSource;
import org.apache.commons.configuration2.SubsetConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSink;
import org.springframework.stereotype.Component;

@Component
public class AtlasDebugMetricsSink
implements MetricsSink {
    private final HashMap<String, DebugMetrics> metricStructuredSnapshot = new HashMap();

    public void putMetrics(MetricsRecord metricsRecord) {
        if (!"AtlasDebugMetricsSource".equals(metricsRecord.name())) {
            return;
        }
        for (AbstractMetric metric : metricsRecord.metrics()) {
            float value = metric.value().floatValue();
            if (value == 0.0f || value == Float.MAX_VALUE || value == Float.MIN_VALUE) continue;
            this.setMetricsData(metric);
        }
    }

    public HashMap getMetrics() {
        return this.metricStructuredSnapshot;
    }

    public void init(SubsetConfiguration subsetConfiguration) {
    }

    public void flush() {
    }

    private void setMetricsData(AbstractMetric metric) {
        String name = metric.name().toLowerCase();
        String fieldCaps = AtlasDebugMetricsSource.fieldLowerCaseUpperCaseMap.get(name);
        if (!StringUtils.isEmpty((String)fieldCaps)) {
            String fieldNameLower = fieldCaps.toLowerCase();
            String metricType = AtlasDebugMetricsSink.inferMeasureType(name, fieldNameLower);
            DebugMetrics debugMetrics = this.metricStructuredSnapshot.get(fieldCaps);
            if (debugMetrics == null) {
                debugMetrics = new DebugMetrics(fieldCaps);
                this.metricStructuredSnapshot.put(fieldCaps, debugMetrics);
            }
            this.updateMetricType(debugMetrics, metricType, metric);
        }
    }

    private void updateMetricType(DebugMetrics debugMetrics, String metricType, AbstractMetric metric) {
        switch (metricType) {
            case "numops": {
                debugMetrics.setNumops(metric.value().intValue());
                break;
            }
            case "mintime": {
                debugMetrics.setMinTime(metric.value().floatValue());
                break;
            }
            case "maxtime": {
                debugMetrics.setMaxTime(metric.value().floatValue());
                break;
            }
            case "stdevtime": {
                debugMetrics.setStdDevTime(metric.value().floatValue());
                break;
            }
            case "avgtime": {
                debugMetrics.setAvgTime(metric.value().floatValue());
            }
        }
    }

    private static String inferMeasureType(String fullName, String nameWithoutMetricType) {
        return fullName.replaceFirst(nameWithoutMetricType, "");
    }
}

