/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.service;

import com.google.common.base.Preconditions;
import java.util.Date;
import javax.inject.Singleton;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.ha.HAConfiguration;
import org.apache.atlas.model.audit.AtlasAuditEntry;
import org.apache.atlas.repository.audit.AtlasAuditService;
import org.apache.atlas.web.service.EmbeddedServer;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Singleton
@Component
public class ServiceState {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceState.class);
    @Autowired
    AtlasAuditService auditService;
    private Configuration configuration;
    private volatile ServiceStateValue state;

    public ServiceState() throws AtlasException {
        this(ApplicationProperties.get());
    }

    public ServiceState(Configuration configuration) {
        this.configuration = configuration;
        ServiceStateValue serviceStateValue = this.state = !HAConfiguration.isHAEnabled((Configuration)configuration) ? ServiceStateValue.ACTIVE : ServiceStateValue.PASSIVE;
        if (!StringUtils.isEmpty((String)configuration.getString("atlas.migration.data.filename", ""))) {
            this.state = ServiceStateValue.MIGRATING;
        }
    }

    public ServiceStateValue getState() {
        return this.state;
    }

    public void becomingActive() {
        LOG.warn("Instance becoming active from {}", (Object)this.state);
        this.setState(ServiceStateValue.BECOMING_ACTIVE);
    }

    private void setState(ServiceStateValue newState) {
        Preconditions.checkState((boolean)HAConfiguration.isHAEnabled((Configuration)this.configuration), (Object)"Cannot change state as requested, as HA is not enabled for this instance.");
        this.state = newState;
        this.auditServerStatus();
    }

    private void auditServerStatus() {
        if (this.state == ServiceStateValue.ACTIVE) {
            Date date = new Date();
            try {
                this.auditService.add(AtlasAuditEntry.AuditOperation.SERVER_START, EmbeddedServer.SERVER_START_TIME, date, null, null, 0L);
                this.auditService.add(AtlasAuditEntry.AuditOperation.SERVER_STATE_ACTIVE, date, date, null, null, 0L);
            }
            catch (AtlasBaseException e) {
                LOG.error("Exception occurred during audit", (Throwable)e);
            }
        }
    }

    public void setActive() {
        LOG.warn("Instance is active from {}", (Object)this.state);
        this.setState(ServiceStateValue.ACTIVE);
    }

    public void becomingPassive() {
        LOG.warn("Instance becoming passive from {}", (Object)this.state);
        this.setState(ServiceStateValue.BECOMING_PASSIVE);
    }

    public void setPassive() {
        LOG.warn("Instance is passive from {}", (Object)this.state);
        this.setState(ServiceStateValue.PASSIVE);
    }

    public boolean isInstanceInTransition() {
        ServiceStateValue state = this.getState();
        return state == ServiceStateValue.BECOMING_ACTIVE || state == ServiceStateValue.BECOMING_PASSIVE;
    }

    public void setMigration() {
        LOG.warn("Instance in {}", (Object)this.state);
        this.setState(ServiceStateValue.MIGRATING);
    }

    public boolean isInstanceInMigration() {
        return this.getState() == ServiceStateValue.MIGRATING;
    }

    public static enum ServiceStateValue {
        ACTIVE,
        PASSIVE,
        BECOMING_ACTIVE,
        BECOMING_PASSIVE,
        MIGRATING;

    }
}

