/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class GraphSerializer
extends SimpleTypeSerializer<Graph> {
    private static final Method openMethod = GraphSerializer.detectGraphOpenMethod();

    public GraphSerializer() {
        super(DataType.GRAPH);
    }

    @Override
    protected Graph readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        if (null == openMethod) {
            throw new IOException("TinkerGraph is an optional dependency to gremlin-driver - if deserializing Graph instances it must be explicitly added as a dependency");
        }
        BaseConfiguration conf = new BaseConfiguration();
        conf.setProperty("gremlin.tinkergraph.defaultVertexPropertyCardinality", (Object)"list");
        try {
            Graph graph = (Graph)openMethod.invoke(null, conf);
            int vertexCount = context.readValue(buffer, Integer.class, false);
            for (int ix = 0; ix < vertexCount; ++ix) {
                Vertex v = graph.addVertex(T.id, context.read(buffer), T.label, context.readValue(buffer, String.class, false));
                int vertexPropertyCount = context.readValue(buffer, Integer.class, false);
                for (int iy = 0; iy < vertexPropertyCount; ++iy) {
                    Object id = context.read(buffer);
                    String label = context.readValue(buffer, String.class, false);
                    Object val = context.read(buffer);
                    context.read(buffer);
                    VertexProperty vp = v.property(VertexProperty.Cardinality.list, label, val, T.id, id);
                    List edgeProperties = context.readValue(buffer, ArrayList.class, false);
                    for (Property p : edgeProperties) {
                        vp.property(p.key(), p.value());
                    }
                }
            }
            int edgeCount = context.readValue(buffer, Integer.class, false);
            for (int ix = 0; ix < edgeCount; ++ix) {
                Object id = context.read(buffer);
                String label = context.readValue(buffer, String.class, false);
                Object inId = context.read(buffer);
                Vertex inV = graph.vertices(inId).next();
                context.read(buffer);
                Object outId = context.read(buffer);
                Vertex outV = graph.vertices(outId).next();
                context.read(buffer);
                context.read(buffer);
                Edge e = outV.addEdge(label, inV, T.id, id);
                List edgeProperties = context.readValue(buffer, ArrayList.class, false);
                for (Property p : edgeProperties) {
                    e.property(p.key(), p.value());
                }
            }
            return graph;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    @Override
    protected void writeValue(Graph value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        List<Vertex> vertexList = IteratorUtils.list(value.vertices(new Object[0]));
        List<Edge> edgeList = IteratorUtils.list(value.edges(new Object[0]));
        context.writeValue(vertexList.size(), buffer, false);
        for (Vertex v : vertexList) {
            this.writeVertex(buffer, context, v);
        }
        context.writeValue(edgeList.size(), buffer, false);
        for (Edge e : edgeList) {
            this.writeEdge(buffer, context, e);
        }
    }

    private void writeVertex(Buffer buffer, GraphBinaryWriter context, Vertex vertex) throws IOException {
        List vertexProperties = IteratorUtils.list(vertex.properties(new String[0]));
        context.write(vertex.id(), buffer);
        context.writeValue(vertex.label(), buffer, false);
        context.writeValue(vertexProperties.size(), buffer, false);
        for (VertexProperty vp : vertexProperties) {
            context.write(vp.id(), buffer);
            context.writeValue(vp.label(), buffer, false);
            context.write(vp.value(), buffer);
            context.write(null, buffer);
            context.writeValue(IteratorUtils.list(vp.properties(new String[0])), buffer, false);
        }
    }

    private void writeEdge(Buffer buffer, GraphBinaryWriter context, Edge edge) throws IOException {
        context.write(edge.id(), buffer);
        context.writeValue(edge.label(), buffer, false);
        context.write(edge.inVertex().id(), buffer);
        context.write(null, buffer);
        context.write(edge.outVertex().id(), buffer);
        context.write(null, buffer);
        context.write(null, buffer);
        context.writeValue(IteratorUtils.list(edge.properties(new String[0])), buffer, false);
    }

    private static Map<String, List<VertexProperty>> indexedVertexProperties(Vertex v) {
        HashMap<String, List<VertexProperty>> index = new HashMap<String, List<VertexProperty>>();
        v.properties(new String[0]).forEachRemaining(vp -> {
            if (!index.containsKey(vp.key())) {
                index.put(vp.key(), new ArrayList());
            }
            ((List)index.get(vp.key())).add(vp);
        });
        return index;
    }

    private static Method detectGraphOpenMethod() {
        Class<?> graphClazz = GraphSerializer.detectTinkerGraph();
        if (null == graphClazz) {
            return null;
        }
        try {
            return graphClazz.getMethod("open", Configuration.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalStateException(nsme);
        }
    }

    private static Class<?> detectTinkerGraph() {
        try {
            return Class.forName("org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph");
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }
}

