/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.EditLogBackupOutputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.JournalManager;
import org.apache.hadoop.hdfs.server.protocol.JournalInfo;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;

class BackupJournalManager
implements JournalManager {
    private final NamenodeRegistration bnReg;
    private final JournalInfo journalInfo;

    BackupJournalManager(NamenodeRegistration bnReg, NamenodeRegistration nnReg) {
        this.journalInfo = new JournalInfo(nnReg.getLayoutVersion(), nnReg.getClusterID(), nnReg.getNamespaceID());
        this.bnReg = bnReg;
    }

    @Override
    public void format(NamespaceInfo nsInfo) {
        throw new UnsupportedOperationException("BackupNode journal should never get formatted");
    }

    @Override
    public boolean hasSomeData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public EditLogOutputStream startLogSegment(long txId, int layoutVersion) throws IOException {
        EditLogBackupOutputStream stm = new EditLogBackupOutputStream(this.bnReg, this.journalInfo, layoutVersion);
        stm.startLogSegment(txId);
        return stm;
    }

    @Override
    public void finalizeLogSegment(long firstTxId, long lastTxId) throws IOException {
    }

    @Override
    public void setOutputBufferCapacity(int size) {
    }

    @Override
    public void purgeLogsOlderThan(long minTxIdToKeep) throws IOException {
    }

    @Override
    public void selectInputStreams(Collection<EditLogInputStream> streams, long fromTxnId, boolean inProgressOk, boolean onlyDurableTxns) {
    }

    @Override
    public void recoverUnfinalizedSegments() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    public boolean matchesRegistration(NamenodeRegistration bnReg) {
        return bnReg.getAddress().equals(this.bnReg.getAddress());
    }

    @Override
    public String toString() {
        return "BackupJournalManager";
    }

    @Override
    public void doPreUpgrade() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void doUpgrade(Storage storage) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void doFinalize() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canRollBack(StorageInfo storage, StorageInfo prevStorage, int targetLayoutVersion) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void doRollback() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void discardSegments(long startTxId) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getJournalCTime() throws IOException {
        throw new UnsupportedOperationException();
    }
}

