/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.AclStorage;
import org.apache.hadoop.hdfs.server.namenode.AclTransformation;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;

class FSDirAclOp {
    FSDirAclOp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileStatus modifyAclEntries(FSDirectory fsd, FSPermissionChecker pc, String srcArg, List<AclEntry> aclSpec) throws IOException {
        INodesInPath iip;
        String src = srcArg;
        FSDirAclOp.checkAclsConfigFlag(fsd);
        fsd.writeLock();
        try {
            iip = fsd.resolvePath(pc, src, FSDirectory.DirOp.WRITE);
            src = iip.getPath();
            fsd.checkOwner(pc, iip);
            INode inode = FSDirectory.resolveLastINode(iip);
            int snapshotId = iip.getLatestSnapshotId();
            List<AclEntry> existingAcl = AclStorage.readINodeLogicalAcl(inode);
            List<AclEntry> newAcl = AclTransformation.mergeAclEntries(existingAcl, aclSpec);
            AclStorage.updateINodeAcl(inode, newAcl, snapshotId);
            fsd.getEditLog().logSetAcl(src, newAcl);
        }
        finally {
            fsd.writeUnlock();
        }
        return fsd.getAuditFileInfo(iip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileStatus removeAclEntries(FSDirectory fsd, FSPermissionChecker pc, String srcArg, List<AclEntry> aclSpec) throws IOException {
        INodesInPath iip;
        String src = srcArg;
        FSDirAclOp.checkAclsConfigFlag(fsd);
        fsd.writeLock();
        try {
            iip = fsd.resolvePath(pc, src, FSDirectory.DirOp.WRITE);
            src = iip.getPath();
            fsd.checkOwner(pc, iip);
            INode inode = FSDirectory.resolveLastINode(iip);
            int snapshotId = iip.getLatestSnapshotId();
            List<AclEntry> existingAcl = AclStorage.readINodeLogicalAcl(inode);
            List<AclEntry> newAcl = AclTransformation.filterAclEntriesByAclSpec(existingAcl, aclSpec);
            AclStorage.updateINodeAcl(inode, newAcl, snapshotId);
            fsd.getEditLog().logSetAcl(src, newAcl);
        }
        finally {
            fsd.writeUnlock();
        }
        return fsd.getAuditFileInfo(iip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileStatus removeDefaultAcl(FSDirectory fsd, FSPermissionChecker pc, String srcArg) throws IOException {
        INodesInPath iip;
        String src = srcArg;
        FSDirAclOp.checkAclsConfigFlag(fsd);
        fsd.writeLock();
        try {
            iip = fsd.resolvePath(pc, src, FSDirectory.DirOp.WRITE);
            src = iip.getPath();
            fsd.checkOwner(pc, iip);
            INode inode = FSDirectory.resolveLastINode(iip);
            int snapshotId = iip.getLatestSnapshotId();
            List<AclEntry> existingAcl = AclStorage.readINodeLogicalAcl(inode);
            List<AclEntry> newAcl = AclTransformation.filterDefaultAclEntries(existingAcl);
            AclStorage.updateINodeAcl(inode, newAcl, snapshotId);
            fsd.getEditLog().logSetAcl(src, newAcl);
        }
        finally {
            fsd.writeUnlock();
        }
        return fsd.getAuditFileInfo(iip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileStatus removeAcl(FSDirectory fsd, FSPermissionChecker pc, String srcArg) throws IOException {
        INodesInPath iip;
        String src = srcArg;
        FSDirAclOp.checkAclsConfigFlag(fsd);
        fsd.writeLock();
        try {
            iip = fsd.resolvePath(pc, src, FSDirectory.DirOp.WRITE);
            src = iip.getPath();
            fsd.checkOwner(pc, iip);
            FSDirAclOp.unprotectedRemoveAcl(fsd, iip);
        }
        finally {
            fsd.writeUnlock();
        }
        fsd.getEditLog().logSetAcl(src, (List<AclEntry>)AclFeature.EMPTY_ENTRY_LIST);
        return fsd.getAuditFileInfo(iip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileStatus setAcl(FSDirectory fsd, FSPermissionChecker pc, String srcArg, List<AclEntry> aclSpec) throws IOException {
        INodesInPath iip;
        String src = srcArg;
        FSDirAclOp.checkAclsConfigFlag(fsd);
        fsd.writeLock();
        try {
            iip = fsd.resolvePath(pc, src, FSDirectory.DirOp.WRITE);
            fsd.checkOwner(pc, iip);
            List<AclEntry> newAcl = FSDirAclOp.unprotectedSetAcl(fsd, iip, aclSpec, false);
            fsd.getEditLog().logSetAcl(iip.getPath(), newAcl);
        }
        finally {
            fsd.writeUnlock();
        }
        return fsd.getAuditFileInfo(iip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AclStatus getAclStatus(FSDirectory fsd, FSPermissionChecker pc, String src) throws IOException {
        FSDirAclOp.checkAclsConfigFlag(fsd);
        fsd.readLock();
        try {
            INodesInPath iip = fsd.resolvePath(pc, src, FSDirectory.DirOp.READ);
            if (iip.isDotSnapshotDir() && fsd.getINode4DotSnapshot(iip) != null) {
                AclStatus aclStatus = new AclStatus.Builder().owner("").group("").build();
                return aclStatus;
            }
            INodeAttributes inodeAttrs = fsd.getAttributes(iip);
            List<AclEntry> acl = AclStorage.readINodeAcl(inodeAttrs);
            FsPermission fsPermission = inodeAttrs.getFsPermission();
            AclStatus aclStatus = new AclStatus.Builder().owner(inodeAttrs.getUserName()).group(inodeAttrs.getGroupName()).stickyBit(fsPermission.getStickyBit()).setPermission(fsPermission).addEntries(acl).build();
            return aclStatus;
        }
        finally {
            fsd.readUnlock();
        }
    }

    static List<AclEntry> unprotectedSetAcl(FSDirectory fsd, INodesInPath iip, List<AclEntry> aclSpec, boolean fromEdits) throws IOException {
        assert (fsd.hasWriteLock());
        if (aclSpec.isEmpty()) {
            FSDirAclOp.unprotectedRemoveAcl(fsd, iip);
            return AclFeature.EMPTY_ENTRY_LIST;
        }
        INode inode = FSDirectory.resolveLastINode(iip);
        int snapshotId = iip.getLatestSnapshotId();
        List<AclEntry> newAcl = aclSpec;
        if (!fromEdits) {
            List<AclEntry> existingAcl = AclStorage.readINodeLogicalAcl(inode);
            newAcl = AclTransformation.replaceAclEntries(existingAcl, aclSpec);
        }
        AclStorage.updateINodeAcl(inode, newAcl, snapshotId);
        return newAcl;
    }

    private static void checkAclsConfigFlag(FSDirectory fsd) throws AclException {
        if (!fsd.isAclsEnabled()) {
            throw new AclException(String.format("The ACL operation has been rejected.  Support for ACLs has been disabled by setting %s to false.", "dfs.namenode.acls.enabled"));
        }
    }

    private static void unprotectedRemoveAcl(FSDirectory fsd, INodesInPath iip) throws IOException {
        assert (fsd.hasWriteLock());
        INode inode = FSDirectory.resolveLastINode(iip);
        int snapshotId = iip.getLatestSnapshotId();
        AclFeature f = inode.getAclFeature();
        if (f == null) {
            return;
        }
        FsPermission perm = inode.getFsPermission();
        ImmutableList<AclEntry> featureEntries = AclStorage.getEntriesFromAclFeature(f);
        if (((AclEntry)featureEntries.get(0)).getScope() == AclEntryScope.ACCESS) {
            AclEntry groupEntryKey = new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.GROUP).build();
            int groupEntryIndex = Collections.binarySearch(featureEntries, groupEntryKey, AclTransformation.ACL_ENTRY_COMPARATOR);
            Preconditions.checkPositionIndex((int)groupEntryIndex, (int)featureEntries.size(), (String)("Invalid group entry index after binary-searching inode: " + inode.getFullPathName() + "(" + inode.getId() + ") with featureEntries:" + featureEntries));
            FsAction groupPerm = ((AclEntry)featureEntries.get(groupEntryIndex)).getPermission();
            FsPermission newPerm = new FsPermission(perm.getUserAction(), groupPerm, perm.getOtherAction(), perm.getStickyBit());
            inode.setPermission(newPerm, snapshotId);
        }
        inode.removeAclFeature(snapshotId);
    }
}

