/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cassandra.thrift.thriftpool;

import java.io.Closeable;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.thrift.transport.TTransport;
import org.janusgraph.diskstorage.cassandra.thrift.thriftpool.CTConnectionFactory;

public class CTConnection
implements Closeable {
    private final TTransport transport;
    private final Cassandra.Client client;
    private final CTConnectionFactory.Config cfg;

    public CTConnection(TTransport transport, Cassandra.Client client, CTConnectionFactory.Config cfg) {
        this.transport = transport;
        this.client = client;
        this.cfg = cfg;
    }

    public TTransport getTransport() {
        return this.transport;
    }

    public Cassandra.Client getClient() {
        return this.client;
    }

    public CTConnectionFactory.Config getConfig() {
        return this.cfg;
    }

    public boolean isOpen() {
        return this.transport.isOpen();
    }

    @Override
    public void close() {
        if (this.transport != null && this.transport.isOpen()) {
            this.transport.close();
        }
    }

    public String toString() {
        return "CTConnection [transport=" + this.transport + ", client=" + this.client + ", cfg=" + this.cfg + "]";
    }
}

