/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.schema;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class Parameter<V> {
    private final String key;
    private final V value;

    public Parameter(String key, V value) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"Invalid key");
        this.key = key;
        this.value = value;
    }

    public static <V> Parameter<V> of(String key, V value) {
        return new Parameter<V>(key, value);
    }

    public String key() {
        return this.key;
    }

    public V value() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (!this.getClass().isInstance(oth)) {
            return false;
        }
        Parameter other = (Parameter)oth;
        return this.key.equals(other.key) && (this.value == other.value || this.value != null && this.value.equals(other.value));
    }

    public String toString() {
        return this.key + "->" + this.value;
    }
}

