/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.indexing;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.AbstractMap;
import java.util.List;
import org.janusgraph.core.Cardinality;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.diskstorage.Mutation;
import org.janusgraph.diskstorage.indexing.IndexEntry;
import org.janusgraph.diskstorage.indexing.KeyInformation;

public class IndexMutation
extends Mutation<IndexEntry, IndexEntry> {
    private final KeyInformation.StoreRetriever storeRetriever;
    private final boolean isNew;
    private boolean isDeleted;
    private final Function<IndexEntry, Object> entryConversionFunction = indexEntry -> this.isCollection(indexEntry.field) ? new AbstractMap.SimpleEntry<String, Object>(indexEntry.field, indexEntry.value) : indexEntry.field;

    public IndexMutation(KeyInformation.StoreRetriever storeRetriever, List<IndexEntry> additions, List<IndexEntry> deletions, boolean isNew, boolean isDeleted) {
        super(additions, deletions);
        Preconditions.checkArgument((!isNew || !isDeleted ? 1 : 0) != 0, (Object)"Invalid status");
        this.storeRetriever = storeRetriever;
        this.isNew = isNew;
        this.isDeleted = isDeleted;
    }

    public IndexMutation(KeyInformation.StoreRetriever storeRetriever, boolean isNew, boolean isDeleted) {
        Preconditions.checkArgument((!isNew || !isDeleted ? 1 : 0) != 0, (Object)"Invalid status");
        this.storeRetriever = storeRetriever;
        this.isNew = isNew;
        this.isDeleted = isDeleted;
    }

    public void merge(IndexMutation m) {
        Preconditions.checkArgument((this.isNew == m.isNew ? 1 : 0) != 0, (Object)"Incompatible new status");
        Preconditions.checkArgument((this.isDeleted == m.isDeleted ? 1 : 0) != 0, (Object)"Incompatible delete status");
        super.merge(m);
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void resetDelete() {
        this.isDeleted = false;
    }

    private boolean isCollection(String field) {
        KeyInformation keyInformation = this.storeRetriever.get(field);
        return keyInformation != null && keyInformation.getCardinality() != Cardinality.SINGLE;
    }

    @Override
    public void consolidate() {
        super.consolidate(this.entryConversionFunction, this.entryConversionFunction);
    }

    @Override
    public boolean isConsolidated() {
        return super.isConsolidated(this.entryConversionFunction, this.entryConversionFunction);
    }

    public int determineTTL() {
        return this.hasDeletions() ? 0 : IndexMutation.determineTTL(this.getAdditions());
    }

    public static int determineTTL(List<IndexEntry> additions) {
        if (additions == null || additions.isEmpty()) {
            return 0;
        }
        int ttl = -1;
        for (IndexEntry add : additions) {
            int ittl = 0;
            if (add.hasMetaData()) {
                Preconditions.checkArgument((add.getMetaData().size() == 1 && add.getMetaData().containsKey((Object)EntryMetaData.TTL) ? 1 : 0) != 0, (String)"Index only supports TTL meta data. Found: %s", (Object[])new Object[]{add.getMetaData()});
                ittl = (Integer)add.getMetaData().get((Object)EntryMetaData.TTL);
            }
            if (ttl < 0) {
                ttl = ittl;
            }
            Preconditions.checkArgument((ttl == ittl ? 1 : 0) != 0, (String)"Index only supports uniform TTL values across all index fields, but got additions: %s", (Object[])new Object[]{additions});
        }
        assert (ttl >= 0);
        return ttl;
    }
}

