/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop;

import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;

public class JanusGraphFeatures
implements Graph.Features {
    private final Graph.Features.GraphFeatures graphFeatures;
    private final Graph.Features.VertexFeatures vertexFeatures;
    private final Graph.Features.EdgeFeatures edgeFeatures;
    private final StandardJanusGraph graph;

    private JanusGraphFeatures(StandardJanusGraph graph, StoreFeatures storageFeatures) {
        this.graphFeatures = new JanusGraphGeneralFeatures(storageFeatures.supportsPersistence());
        this.vertexFeatures = new JanusGraphVertexFeatures();
        this.edgeFeatures = new JanusGraphEdgeFeatures();
        this.graph = graph;
    }

    public Graph.Features.GraphFeatures graph() {
        return this.graphFeatures;
    }

    public Graph.Features.VertexFeatures vertex() {
        return this.vertexFeatures;
    }

    public Graph.Features.EdgeFeatures edge() {
        return this.edgeFeatures;
    }

    public String toString() {
        return StringFactory.featureString((Graph.Features)this);
    }

    public static JanusGraphFeatures getFeatures(StandardJanusGraph graph, StoreFeatures storageFeatures) {
        return new JanusGraphFeatures(graph, storageFeatures);
    }

    private static class JanusGraphEdgeFeatures
    implements Graph.Features.EdgeFeatures {
        private JanusGraphEdgeFeatures() {
        }

        public Graph.Features.EdgePropertyFeatures properties() {
            return new JanusGraphEdgePropertyFeatures();
        }

        public boolean supportsCustomIds() {
            return true;
        }

        public boolean supportsUserSuppliedIds() {
            return false;
        }

        public boolean supportsNumericIds() {
            return false;
        }

        public boolean supportsAnyIds() {
            return false;
        }

        public boolean supportsUuidIds() {
            return false;
        }

        public boolean supportsStringIds() {
            return false;
        }
    }

    private class JanusGraphVertexFeatures
    implements Graph.Features.VertexFeatures {
        private JanusGraphVertexFeatures() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VertexProperty.Cardinality getCardinality(String key) {
            StandardJanusGraphTx tx = (StandardJanusGraphTx)JanusGraphFeatures.this.graph.newTransaction();
            try {
                if (!tx.containsPropertyKey(key)) {
                    VertexProperty.Cardinality cardinality = tx.getConfiguration().getAutoSchemaMaker().defaultPropertyCardinality(key).convert();
                    return cardinality;
                }
                VertexProperty.Cardinality cardinality = tx.getPropertyKey(key).cardinality().convert();
                return cardinality;
            }
            finally {
                tx.rollback();
            }
        }

        public Graph.Features.VertexPropertyFeatures properties() {
            return new JanusGraphVertexPropertyFeatures();
        }

        public boolean supportsNumericIds() {
            return true;
        }

        public boolean supportsUserSuppliedIds() {
            return JanusGraphFeatures.this.graph.getConfiguration().allowVertexIdSetting();
        }

        public boolean supportsAnyIds() {
            return false;
        }

        public boolean supportsUuidIds() {
            return false;
        }

        public boolean supportsStringIds() {
            return false;
        }

        public boolean supportsCustomIds() {
            return false;
        }
    }

    private static class JanusGraphEdgePropertyFeatures
    extends JanusGraphDataTypeFeatures
    implements Graph.Features.EdgePropertyFeatures {
        private JanusGraphEdgePropertyFeatures() {
        }
    }

    private static class JanusGraphVertexPropertyFeatures
    extends JanusGraphDataTypeFeatures
    implements Graph.Features.VertexPropertyFeatures {
        private JanusGraphVertexPropertyFeatures() {
        }

        public boolean supportsUserSuppliedIds() {
            return false;
        }

        public boolean supportsNumericIds() {
            return false;
        }

        public boolean supportsAnyIds() {
            return false;
        }

        public boolean supportsUuidIds() {
            return false;
        }
    }

    private static class JanusGraphGeneralFeatures
    extends JanusGraphDataTypeFeatures
    implements Graph.Features.GraphFeatures {
        private final boolean persists;

        private JanusGraphGeneralFeatures(boolean persists) {
            this.persists = persists;
        }

        public Graph.Features.VariableFeatures variables() {
            return new JanusGraphVariableFeatures();
        }

        public boolean supportsComputer() {
            return true;
        }

        public boolean supportsPersistence() {
            return this.persists;
        }

        public boolean supportsTransactions() {
            return true;
        }

        public boolean supportsThreadedTransactions() {
            return true;
        }
    }

    private static class JanusGraphVariableFeatures
    extends JanusGraphDataTypeFeatures
    implements Graph.Features.VariableFeatures {
        private JanusGraphVariableFeatures() {
        }
    }

    private static class JanusGraphDataTypeFeatures
    implements Graph.Features.DataTypeFeatures {
        private JanusGraphDataTypeFeatures() {
        }

        public boolean supportsMapValues() {
            return true;
        }

        public boolean supportsMixedListValues() {
            return false;
        }

        public boolean supportsSerializableValues() {
            return false;
        }

        public boolean supportsUniformListValues() {
            return false;
        }
    }
}

