/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.gremlin.server.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpMessage;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.auth.Authenticator;
import org.apache.tinkerpop.gremlin.server.handler.SaslAuthenticationHandler;
import org.janusgraph.graphdb.tinkerpop.gremlin.server.auth.HMACAuthenticator;
import org.janusgraph.graphdb.tinkerpop.gremlin.server.auth.SaslAndHMACAuthenticator;
import org.janusgraph.graphdb.tinkerpop.gremlin.server.handler.HttpHMACAuthenticationHandler;

@ChannelHandler.Sharable
public class SaslAndHMACAuthenticationHandler
extends SaslAuthenticationHandler {
    private final String HMAC_AUTH = "hmac_authenticator";
    private HMACAuthenticator hmacAuthenticator;

    public SaslAndHMACAuthenticationHandler(Authenticator authenticator, Settings.AuthenticationSettings authenticationSettings) {
        super((Authenticator)((SaslAndHMACAuthenticator)authenticator).getSimpleAuthenticator(), authenticationSettings);
        this.hmacAuthenticator = ((SaslAndHMACAuthenticator)authenticator).getHMACAuthenticator();
    }

    public void channelRead(ChannelHandlerContext ctx, Object obj) throws Exception {
        if (obj instanceof HttpMessage && !this.isWebSocket((HttpMessage)obj)) {
            if (null == ctx.pipeline().get("hmac_authenticator")) {
                HttpHMACAuthenticationHandler authHandler = new HttpHMACAuthenticationHandler(this.hmacAuthenticator);
                ctx.pipeline().addAfter("authenticator", "hmac_authenticator", (ChannelHandler)authHandler);
            }
            ctx.fireChannelRead(obj);
        } else {
            super.channelRead(ctx, obj);
        }
    }

    private boolean isWebSocket(HttpMessage msg) {
        String connectionHeader = msg.headers().get("Connection");
        String upgradeHeader = msg.headers().get("Upgrade");
        return null != connectionHeader && connectionHeader.equalsIgnoreCase("Upgrade") || null != upgradeHeader && upgradeHeader.equalsIgnoreCase("WebSocket");
    }
}

