/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.BasePartitionState;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.utils.Utils;

public class LeaderAndIsrRequest
extends AbstractRequest {
    private static final String CONTROLLER_ID_KEY_NAME = "controller_id";
    private static final String CONTROLLER_EPOCH_KEY_NAME = "controller_epoch";
    private static final String PARTITION_STATES_KEY_NAME = "partition_states";
    private static final String LIVE_LEADERS_KEY_NAME = "live_leaders";
    private static final String LEADER_KEY_NAME = "leader";
    private static final String LEADER_EPOCH_KEY_NAME = "leader_epoch";
    private static final String ISR_KEY_NAME = "isr";
    private static final String ZK_VERSION_KEY_NAME = "zk_version";
    private static final String REPLICAS_KEY_NAME = "replicas";
    private static final String IS_NEW_KEY_NAME = "is_new";
    private static final String END_POINT_ID_KEY_NAME = "id";
    private static final String HOST_KEY_NAME = "host";
    private static final String PORT_KEY_NAME = "port";
    private static final Schema LEADER_AND_ISR_REQUEST_PARTITION_STATE_V0 = new Schema(CommonFields.TOPIC_NAME, CommonFields.PARTITION_ID, new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The broker id for the leader."), new Field("leader_epoch", Type.INT32, "The leader epoch."), new Field("isr", new ArrayOf(Type.INT32), "The in sync replica ids."), new Field("zk_version", Type.INT32, "The ZK version."), new Field("replicas", new ArrayOf(Type.INT32), "The replica ids."));
    private static final Schema LEADER_AND_ISR_REQUEST_PARTITION_STATE_V1 = new Schema(CommonFields.TOPIC_NAME, CommonFields.PARTITION_ID, new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The broker id for the leader."), new Field("leader_epoch", Type.INT32, "The leader epoch."), new Field("isr", new ArrayOf(Type.INT32), "The in sync replica ids."), new Field("zk_version", Type.INT32, "The ZK version."), new Field("replicas", new ArrayOf(Type.INT32), "The replica ids."), new Field("is_new", Type.BOOLEAN, "Whether the replica should have existed on the broker or not"));
    private static final Schema LEADER_AND_ISR_REQUEST_LIVE_LEADER_V0 = new Schema(new Field("id", Type.INT32, "The broker id."), new Field("host", Type.STRING, "The hostname of the broker."), new Field("port", Type.INT32, "The port on which the broker accepts requests."));
    private static final Schema LEADER_AND_ISR_REQUEST_V0 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("partition_states", new ArrayOf(LEADER_AND_ISR_REQUEST_PARTITION_STATE_V0)), new Field("live_leaders", new ArrayOf(LEADER_AND_ISR_REQUEST_LIVE_LEADER_V0)));
    private static final Schema LEADER_AND_ISR_REQUEST_V1 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("partition_states", new ArrayOf(LEADER_AND_ISR_REQUEST_PARTITION_STATE_V1)), new Field("live_leaders", new ArrayOf(LEADER_AND_ISR_REQUEST_LIVE_LEADER_V0)));
    private final int controllerId;
    private final int controllerEpoch;
    private final Map<TopicPartition, PartitionState> partitionStates;
    private final Set<Node> liveLeaders;

    public static Schema[] schemaVersions() {
        return new Schema[]{LEADER_AND_ISR_REQUEST_V0, LEADER_AND_ISR_REQUEST_V1};
    }

    private LeaderAndIsrRequest(int controllerId, int controllerEpoch, Map<TopicPartition, PartitionState> partitionStates, Set<Node> liveLeaders, short version) {
        super(ApiKeys.LEADER_AND_ISR, version);
        this.controllerId = controllerId;
        this.controllerEpoch = controllerEpoch;
        this.partitionStates = partitionStates;
        this.liveLeaders = liveLeaders;
    }

    public LeaderAndIsrRequest(Struct struct, short version) {
        super(ApiKeys.LEADER_AND_ISR, version);
        HashMap<TopicPartition, PartitionState> partitionStates = new HashMap<TopicPartition, PartitionState>();
        for (Object partitionStateDataObj : struct.getArray(PARTITION_STATES_KEY_NAME)) {
            Struct partitionStateData = (Struct)partitionStateDataObj;
            String topic = partitionStateData.get(CommonFields.TOPIC_NAME);
            int partition = partitionStateData.get(CommonFields.PARTITION_ID);
            int controllerEpoch = partitionStateData.getInt(CONTROLLER_EPOCH_KEY_NAME);
            int leader = partitionStateData.getInt(LEADER_KEY_NAME);
            int leaderEpoch = partitionStateData.getInt(LEADER_EPOCH_KEY_NAME);
            Object[] isrArray = partitionStateData.getArray(ISR_KEY_NAME);
            ArrayList<Integer> isr = new ArrayList<Integer>(isrArray.length);
            for (Object object : isrArray) {
                isr.add((Integer)object);
            }
            int zkVersion = partitionStateData.getInt(ZK_VERSION_KEY_NAME);
            Object[] replicasArray = partitionStateData.getArray(REPLICAS_KEY_NAME);
            ArrayList<Integer> replicas = new ArrayList<Integer>(replicasArray.length);
            for (Object r3 : replicasArray) {
                replicas.add((Integer)r3);
            }
            boolean bl = partitionStateData.hasField(IS_NEW_KEY_NAME) ? partitionStateData.getBoolean(IS_NEW_KEY_NAME) : false;
            PartitionState partitionState = new PartitionState(controllerEpoch, leader, leaderEpoch, isr, zkVersion, replicas, bl);
            partitionStates.put(new TopicPartition(topic, partition), partitionState);
        }
        HashSet<Node> leaders = new HashSet<Node>();
        for (Object leadersDataObj : struct.getArray(LIVE_LEADERS_KEY_NAME)) {
            Struct leadersData = (Struct)leadersDataObj;
            int id = leadersData.getInt(END_POINT_ID_KEY_NAME);
            String host = leadersData.getString(HOST_KEY_NAME);
            int port = leadersData.getInt(PORT_KEY_NAME);
            leaders.add(new Node(id, host, port));
        }
        this.controllerId = struct.getInt(CONTROLLER_ID_KEY_NAME);
        this.controllerEpoch = struct.getInt(CONTROLLER_EPOCH_KEY_NAME);
        this.partitionStates = partitionStates;
        this.liveLeaders = leaders;
    }

    @Override
    protected Struct toStruct() {
        short version = this.version();
        Struct struct = new Struct(ApiKeys.LEADER_AND_ISR.requestSchema(version));
        struct.set(CONTROLLER_ID_KEY_NAME, (Object)this.controllerId);
        struct.set(CONTROLLER_EPOCH_KEY_NAME, (Object)this.controllerEpoch);
        ArrayList<Struct> partitionStatesData = new ArrayList<Struct>(this.partitionStates.size());
        for (Map.Entry<TopicPartition, PartitionState> entry : this.partitionStates.entrySet()) {
            Struct partitionStateData = struct.instance(PARTITION_STATES_KEY_NAME);
            TopicPartition topicPartition = entry.getKey();
            partitionStateData.set(CommonFields.TOPIC_NAME, topicPartition.topic());
            partitionStateData.set(CommonFields.PARTITION_ID, topicPartition.partition());
            PartitionState partitionState = entry.getValue();
            partitionStateData.set(CONTROLLER_EPOCH_KEY_NAME, (Object)partitionState.basePartitionState.controllerEpoch);
            partitionStateData.set(LEADER_KEY_NAME, (Object)partitionState.basePartitionState.leader);
            partitionStateData.set(LEADER_EPOCH_KEY_NAME, (Object)partitionState.basePartitionState.leaderEpoch);
            partitionStateData.set(ISR_KEY_NAME, (Object)partitionState.basePartitionState.isr.toArray());
            partitionStateData.set(ZK_VERSION_KEY_NAME, (Object)partitionState.basePartitionState.zkVersion);
            partitionStateData.set(REPLICAS_KEY_NAME, (Object)partitionState.basePartitionState.replicas.toArray());
            if (partitionStateData.hasField(IS_NEW_KEY_NAME)) {
                partitionStateData.set(IS_NEW_KEY_NAME, (Object)partitionState.isNew);
            }
            partitionStatesData.add(partitionStateData);
        }
        struct.set(PARTITION_STATES_KEY_NAME, (Object)partitionStatesData.toArray());
        ArrayList<Struct> leadersData = new ArrayList<Struct>(this.liveLeaders.size());
        for (Node leader : this.liveLeaders) {
            Struct leaderData = struct.instance(LIVE_LEADERS_KEY_NAME);
            leaderData.set(END_POINT_ID_KEY_NAME, (Object)leader.id());
            leaderData.set(HOST_KEY_NAME, (Object)leader.host());
            leaderData.set(PORT_KEY_NAME, (Object)leader.port());
            leadersData.add(leaderData);
        }
        struct.set(LIVE_LEADERS_KEY_NAME, (Object)leadersData.toArray());
        return struct;
    }

    @Override
    public LeaderAndIsrResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        HashMap<TopicPartition, Errors> responses = new HashMap<TopicPartition, Errors>(this.partitionStates.size());
        for (TopicPartition partition : this.partitionStates.keySet()) {
            responses.put(partition, error);
        }
        short versionId = this.version();
        switch (versionId) {
            case 0: 
            case 1: {
                return new LeaderAndIsrResponse(error, responses);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.LEADER_AND_ISR.latestVersion()));
    }

    public int controllerId() {
        return this.controllerId;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public Map<TopicPartition, PartitionState> partitionStates() {
        return this.partitionStates;
    }

    public Set<Node> liveLeaders() {
        return this.liveLeaders;
    }

    public static LeaderAndIsrRequest parse(ByteBuffer buffer, short version) {
        return new LeaderAndIsrRequest(ApiKeys.LEADER_AND_ISR.parseRequest(version, buffer), version);
    }

    public static final class PartitionState {
        public final BasePartitionState basePartitionState;
        public final boolean isNew;

        public PartitionState(int controllerEpoch, int leader, int leaderEpoch, List<Integer> isr, int zkVersion, List<Integer> replicas, boolean isNew) {
            this.basePartitionState = new BasePartitionState(controllerEpoch, leader, leaderEpoch, isr, zkVersion, replicas);
            this.isNew = isNew;
        }

        public String toString() {
            return "PartitionState(controllerEpoch=" + this.basePartitionState.controllerEpoch + ", leader=" + this.basePartitionState.leader + ", leaderEpoch=" + this.basePartitionState.leaderEpoch + ", isr=" + Utils.join(this.basePartitionState.isr, ",") + ", zkVersion=" + this.basePartitionState.zkVersion + ", replicas=" + Utils.join(this.basePartitionState.replicas, ",") + ", isNew=" + this.isNew + ")";
        }
    }

    public static class Builder
    extends AbstractRequest.Builder<LeaderAndIsrRequest> {
        private final int controllerId;
        private final int controllerEpoch;
        private final Map<TopicPartition, PartitionState> partitionStates;
        private final Set<Node> liveLeaders;

        public Builder(short version, int controllerId, int controllerEpoch, Map<TopicPartition, PartitionState> partitionStates, Set<Node> liveLeaders) {
            super(ApiKeys.LEADER_AND_ISR, version);
            this.controllerId = controllerId;
            this.controllerEpoch = controllerEpoch;
            this.partitionStates = partitionStates;
            this.liveLeaders = liveLeaders;
        }

        @Override
        public LeaderAndIsrRequest build(short version) {
            return new LeaderAndIsrRequest(this.controllerId, this.controllerEpoch, this.partitionStates, this.liveLeaders, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=LeaderAndIsRequest").append(", controllerId=").append(this.controllerId).append(", controllerEpoch=").append(this.controllerEpoch).append(", partitionStates=").append(this.partitionStates).append(", liveLeaders=(").append(Utils.join(this.liveLeaders, ", ")).append(")").append(")");
            return bld.toString();
        }
    }
}

