/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.classfinal;

import java.io.File;
import java.util.List;
import java.util.Scanner;
import net.roseboy.classfinal.Const;
import net.roseboy.classfinal.JarEncryptor;
import net.roseboy.classfinal.util.CmdLineOption;
import net.roseboy.classfinal.util.IoUtils;
import net.roseboy.classfinal.util.JarUtils;
import net.roseboy.classfinal.util.Log;
import net.roseboy.classfinal.util.StrUtils;
import net.roseboy.classfinal.util.SysUtils;

public class Main {
    public static void main(String[] args) {
        String yes;
        String code;
        String cfgfiles;
        String classpath;
        String excludeClass;
        String packages;
        String libjars;
        Const.pringInfo();
        Scanner scanner = new Scanner(System.in);
        CmdLineOption cmd = new CmdLineOption();
        cmd.addOption("packages", true, "\u52a0\u5bc6\u7684\u5305\u540d(\u53ef\u4e3a\u7a7a,\u591a\u4e2a\u7528\",\"\u5206\u5272)");
        cmd.addOption("pwd", true, "\u52a0\u5bc6\u5bc6\u7801");
        cmd.addOption("code", true, "\u673a\u5668\u7801");
        cmd.addOption("exclude", true, "\u6392\u9664\u7684\u7c7b\u540d(\u53ef\u4e3a\u7a7a,\u591a\u4e2a\u7528\",\"\u5206\u5272)");
        cmd.addOption("file", true, "\u52a0\u5bc6\u7684jar/war\u8def\u5f84");
        cmd.addOption("libjars", true, "jar/war lib\u4e0b\u7684jar(\u53ef\u4e3a\u7a7a,\u591a\u4e2a\u7528\",\"\u5206\u5272)");
        cmd.addOption("classpath", true, "\u4f9d\u8d56jar\u5305\u76ee\u5f55(\u53ef\u4e3a\u7a7a,\u591a\u4e2a\u7528\",\"\u5206\u5272)");
        cmd.addOption("cfgfiles", true, "\u9700\u8981\u52a0\u5bc6\u7684\u914d\u7f6e\u6587\u4ef6(\u53ef\u4e3a\u7a7a,\u591a\u4e2a\u7528\",\"\u5206\u5272)");
        cmd.addOption("Y", false, "\u65e0\u9700\u786e\u8ba4");
        cmd.addOption("debug", false, "\u8c03\u8bd5\u6a21\u5f0f");
        cmd.addOption("C", false, "\u751f\u6210\u673a\u5668\u7801");
        cmd.parse(args);
        if (cmd.hasOption("C")) {
            Main.makeCode();
            return;
        }
        String path = null;
        String password = null;
        if (args == null || args.length == 0) {
            while (StrUtils.isEmpty(path)) {
                Log.print("\u8bf7\u8f93\u5165\u9700\u8981\u52a0\u5bc6\u7684jar/war\u8def\u5f84:");
                path = scanner.nextLine();
            }
            Log.print("\u8bf7\u8f93\u5165jar/war\u5305lib\u4e0b\u8981\u52a0\u5bc6jar\u6587\u4ef6\u540d(\u591a\u4e2a\u7528\",\"\u5206\u5272):");
            libjars = scanner.nextLine();
            Log.print("\u8bf7\u8f93\u5165\u9700\u8981\u52a0\u5bc6\u7684\u5305\u540d(\u53ef\u4e3a\u7a7a,\u591a\u4e2a\u7528\",\"\u5206\u5272):");
            packages = scanner.nextLine();
            Log.print("\u8bf7\u8f93\u5165\u9700\u8981\u6392\u9664\u7684\u7c7b\u540d(\u53ef\u4e3a\u7a7a,\u591a\u4e2a\u7528\",\"\u5206\u5272):");
            excludeClass = scanner.nextLine();
            Log.print("\u8bf7\u8f93\u5165\u4f9d\u8d56jar\u5305\u76ee\u5f55(\u53ef\u4e3a\u7a7a,\u591a\u4e2a\u7528\",\"\u5206\u5272):");
            classpath = scanner.nextLine();
            Log.print("\u8bf7\u8f93\u5165\u8981\u52a0\u5bc6\u7684\u914d\u7f6e\u6587\u4ef6\u540d(\u53ef\u4e3a\u7a7a,\u591a\u4e2a\u7528\",\"\u5206\u5272):");
            cfgfiles = scanner.nextLine();
            Log.print("\u8bf7\u8f93\u5165\u673a\u5668\u7801(\u53ef\u4e3a\u7a7a):");
            code = scanner.nextLine();
            while (StrUtils.isEmpty(password)) {
                Log.print("\u8bf7\u8f93\u5165\u52a0\u5bc6\u5bc6\u7801:");
                password = scanner.nextLine();
            }
        } else {
            path = cmd.getOptionValue("file", "");
            libjars = cmd.getOptionValue("libjars", "");
            packages = cmd.getOptionValue("packages", "");
            excludeClass = cmd.getOptionValue("exclude", "");
            classpath = cmd.getOptionValue("classpath", "");
            password = cmd.getOptionValue("pwd", "");
            code = cmd.getOptionValue("code", "");
            cfgfiles = cmd.getOptionValue("cfgfiles", "");
        }
        if ("1".equals(path)) {
            path = "/Users/roseboy/fsdownload/yiyon-package-liuyuan-1.0.0.jar";
            libjars = "yiyon-*.jar,aspectjweaver-1.8.13.jar,a.jar";
            packages = "com.yiyon,net.roseboy.*";
            excludeClass = "org.spring.*";
            password = "123456";
            classpath = "/Users/roseboy/code-space/apache-tomcat-8.5.32/lib";
            cfgfiles = "*.yml";
            Const.DEBUG = false;
        } else if ("2".equals(path)) {
            path = "/Users/roseboy/code-space/pig_project/target/pig_project_maven.war";
            packages = "net.roseboy";
            excludeClass = "org.spring";
            password = "#";
            classpath = "/Users/roseboy/code-space/apache-tomcat-8.5.32/lib";
            Const.DEBUG = true;
        } else if ("3".equals(path)) {
            path = "/Users/roseboy/Desktop/iyun.node.dicomserver.jar";
            packages = "com,org";
            password = "1234";
            Const.DEBUG = true;
        }
        Log.println();
        Log.println("\u52a0\u5bc6\u4fe1\u606f\u5982\u4e0b:");
        Log.println("-------------------------");
        Log.println("1. jar/war\u8def\u5f84:      " + path);
        Log.println("2. lib\u4e0b\u7684jar:       " + libjars);
        Log.println("3. \u5305\u540d\u524d\u7f00:          " + packages);
        Log.println("4. \u6392\u9664\u7684\u7c7b\u540d:        " + excludeClass);
        Log.println("5. \u52a0\u5bc6\u914d\u7f6e\u6587\u4ef6:      " + cfgfiles);
        Log.println("6. ClassPath:       " + classpath);
        Log.println("7. \u5bc6\u7801:             " + password);
        Log.println("8. \u673a\u5668\u7801:           " + code);
        Log.println("-------------------------");
        Log.println();
        if (cmd.hasOption("Y")) {
            yes = "Y";
        } else {
            Log.println("\u786e\u5b9a\u6267\u884c\u5417\uff1f(Y/n)");
            yes = scanner.nextLine();
            while (!"n".equals(yes) && !"Y".equals(yes)) {
                Log.println("Yes or No \uff1f[Y/n]");
                yes = scanner.nextLine();
            }
        }
        IoUtils.close(scanner);
        if (!"Y".equals(yes)) {
            Log.println("\u5df2\u53d6\u6d88\uff01");
            return;
        }
        Log.println("\u5904\u7406\u4e2d...");
        List<String> includeJarList = StrUtils.toList(libjars);
        List<String> packageList = StrUtils.toList(packages);
        List<String> excludeClassList = StrUtils.toList(excludeClass);
        List<String> classPathList = StrUtils.toList(classpath);
        List<String> cfgFileList = StrUtils.toList(cfgfiles);
        includeJarList.add("-");
        JarEncryptor encryptor = new JarEncryptor(path, password.trim().toCharArray());
        encryptor.setCode(StrUtils.isEmpty(code) ? null : code.trim().toCharArray());
        encryptor.setPackages(packageList);
        encryptor.setIncludeJars(includeJarList);
        encryptor.setExcludeClass(excludeClassList);
        encryptor.setClassPath(classPathList);
        encryptor.setCfgfiles(cfgFileList);
        try {
            String result = encryptor.doEncryptJar();
            Log.println("\u52a0\u5bc6\u5b8c\u6210\uff0c\u8bf7\u7262\u8bb0\u5bc6\u7801\uff01");
            Log.println("==>" + result);
        }
        catch (Exception e) {
            Log.println("ERROR: " + e.getMessage());
        }
    }

    public static void makeCode() {
        String path = JarUtils.getRootPath(null);
        path = path.substring(0, path.lastIndexOf("/") + 1);
        String code = new String(SysUtils.makeMarchinCode());
        File file = new File(path, "classfinal-code.txt");
        IoUtils.writeTxtFile(file, code);
        Log.println("Server code is: " + code);
        Log.println("==>" + file.getAbsolutePath());
        Log.println();
    }
}

