/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.classfinal.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.Bytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.Descriptor;
import javassist.compiler.CompileError;
import javassist.compiler.Javac;
import net.roseboy.classfinal.util.IoUtils;

public class ClassUtils {
    public static byte[] rewriteAllMethods(ClassPool pool, String classname) {
        String name = null;
        try {
            CtMethod[] methods;
            CtClass cc = pool.getCtClass(classname);
            for (CtMethod m : methods = cc.getDeclaredMethods()) {
                CodeAttribute ca;
                name = m.getName();
                if (m.getName().contains("<") || !m.getLongName().startsWith(cc.getName()) || (ca = m.getMethodInfo().getCodeAttribute()) == null || ca.getCodeLength() == 1 || ca.getCode()[0] == -79) continue;
                ClassUtils.setBodyKeepParamInfos(m, null, true);
                if (!"void".equalsIgnoreCase(m.getReturnType().getName()) || !m.getLongName().endsWith(".main(java.lang.String[])") || m.getMethodInfo().getAccessFlags() != 9) continue;
                m.insertBefore("System.out.println(\"\\nStartup failed, invalid password.\\n\");");
            }
            return cc.toBytecode();
        }
        catch (Exception e) {
            throw new RuntimeException("[" + classname + "(" + name + ")]" + e.getMessage());
        }
    }

    public static void setBodyKeepParamInfos(CtMethod m, String src, boolean rebuild) throws CannotCompileException {
        CtClass cc = m.getDeclaringClass();
        if (cc.isFrozen()) {
            throw new RuntimeException(cc.getName() + " class is frozen");
        }
        CodeAttribute ca = m.getMethodInfo().getCodeAttribute();
        if (ca == null) {
            throw new CannotCompileException("no method body");
        }
        CodeIterator iterator = ca.iterator();
        Javac jv = new Javac(cc);
        try {
            int nvars = jv.recordParams(m.getParameterTypes(), Modifier.isStatic(m.getModifiers()));
            jv.recordParamNames(ca, nvars);
            jv.recordLocalVariables(ca, 0);
            jv.recordReturnType(Descriptor.getReturnType(m.getMethodInfo().getDescriptor(), cc.getClassPool()), false);
            Bytecode b = jv.compileBody(m, src);
            int stack = b.getMaxStack();
            int locals = b.getMaxLocals();
            if (stack > ca.getMaxStack()) {
                ca.setMaxStack(stack);
            }
            if (locals > ca.getMaxLocals()) {
                ca.setMaxLocals(locals);
            }
            int pos = iterator.insertEx(b.get());
            iterator.insert(b.getExceptionTable(), pos);
            if (rebuild) {
                m.getMethodInfo().rebuildStackMapIf6(cc.getClassPool(), cc.getClassFile2());
            }
        }
        catch (NotFoundException var12) {
            throw new CannotCompileException(var12);
        }
        catch (CompileError var13) {
            throw new CannotCompileException(var13);
        }
        catch (BadBytecode var14) {
            throw new CannotCompileException(var14);
        }
    }

    public static void loadClassPath(ClassPool pool, List<String> paths) {
        for (String path : paths) {
            ClassUtils.loadClassPath(pool, new File(path));
        }
    }

    public static void loadClassPath(ClassPool pool, File dir) {
        block7: {
            block6: {
                if (dir == null || !dir.exists()) {
                    return;
                }
                if (!dir.isDirectory()) break block6;
                ArrayList<File> jars = new ArrayList<File>();
                IoUtils.listFile(jars, dir, ".jar");
                for (File jar : jars) {
                    try {
                        pool.insertClassPath(jar.getAbsolutePath());
                    }
                    catch (NotFoundException notFoundException) {}
                }
                break block7;
            }
            if (!dir.getName().endsWith(".jar")) break block7;
            try {
                pool.insertClassPath(dir.getAbsolutePath());
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }

    public static byte[] insertCode(String classMethod, String javaCode, int line, File libDir, File thisJar) throws Exception {
        String className = classMethod.split("#")[0];
        String methodName = classMethod.split("#")[1];
        ClassPool pool = ClassPool.getDefault();
        ClassUtils.loadClassPath(pool, libDir);
        if (thisJar != null && thisJar.exists()) {
            ClassUtils.loadClassPath(pool, thisJar);
        }
        CtClass cc = pool.getCtClass(className);
        if (methodName.startsWith("<") && methodName.contains(">")) {
            CtConstructor[] ms;
            methodName = methodName.replace("<", "").replace(">", "");
            for (CtConstructor mt : ms = cc.getConstructors()) {
                if (!mt.getLongName().endsWith(methodName)) continue;
                mt.insertAt(line, javaCode);
            }
        } else {
            CtMethod mt = cc.getDeclaredMethod(methodName);
            mt.insertAt(line, javaCode);
        }
        byte[] bytes = cc.toBytecode();
        return bytes;
    }
}

